/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChinchillaEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BATHING = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean orderedToSit;
    public static final float DEFAULT_HEALTH = 8.0f;
    public static final float TAMED_HEALTH = 20.0f;

    public ChinchillaEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
            this.m_21153_(8.0f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(BATHING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("Bathing", this.isDustBathing());
        tag.m_128379_("Sitting", this.orderedToSit);
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.setSleeping(tag.m_128471_("Bathing"));
        this.m_21837_(this.orderedToSit);
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new DustBatheGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DustBatheSuspiciousGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(2, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 1.3, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && !ChinchillaEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21825_()) {
            this.m_21573_().m_26573_();
            this.m_20242_(false);
        } else {
            this.m_20242_(false);
            this.m_21573_().m_26569_();
        }
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_21827_() {
        return this.orderedToSit;
    }

    public void m_21839_(boolean isSitting) {
        this.orderedToSit = isSitting;
    }

    public boolean m_21825_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21837_(boolean sitting) {
        super.m_21837_(sitting);
        this.orderedToSit = sitting;
        if (sitting) {
            this.m_21573_().m_26573_();
        }
    }

    public static boolean canSpawn(EntityType<ChinchillaEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<ChinchillaEntity> event) {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().then("stand", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDustBathing()) {
            BlockParticleOption gravelParticle = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49994_.m_49966_());
            for (int i = 0; i < 3; ++i) {
                double offsetX = ((double)this.m_217043_().m_188501_() - 0.5) * 0.5;
                double offsetZ = ((double)this.m_217043_().m_188501_() - 0.5) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)gravelParticle, this.m_20185_() + offsetX, this.m_20186_() + 0.1, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
            event.getController().setAnimation(RawAnimation.begin().then("bath", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public boolean isDustBathing() {
        this.m_5496_(SoundEvents.f_12334_, 0.5f, 1.0f);
        this.m_21573_().m_26573_();
        return (Boolean)this.f_19804_.m_135370_(BATHING);
    }

    public void setDustBathing(boolean bathing) {
        this.f_19804_.m_135381_(BATHING, (Object)bathing);
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42405_;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public ChinchillaEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        ChinchillaEntity babyChinchilla = (ChinchillaEntity)((EntityType)FaunifyEntities.CHINCHILLA.get()).m_20615_((Level)serverLevel);
        if (babyChinchilla != null && otherParent instanceof ChinchillaEntity) {
            ChinchillaEntity parent = (ChinchillaEntity)otherParent;
            Variant selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            babyChinchilla.setVariant(selectedVariant);
        }
        return babyChinchilla;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(3);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_2.get();
            }
            case 2: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_3.get();
            }
        }
        return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.CHINCHILLA_HURT.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (this.m_21825_()) {
            double knockbackStrength = 0.05;
            double directionX = this.m_20185_() - source.m_7639_().m_20185_();
            double directionZ = this.m_20189_() - source.m_7639_().m_20189_();
            double length = Math.sqrt(directionX * directionX + directionZ * directionZ);
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.3, 0.0));
            this.m_20256_(this.m_20184_().m_82520_(directionX / length * knockbackStrength, 0.0, directionZ / length * knockbackStrength));
            this.m_21837_(false);
        }
        return result;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (item == Items.f_41939_) {
                if (this.m_21223_() < this.m_21233_()) {
                    int particleCount = 5;
                    this.m_5634_(3.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    for (int i = 0; i < particleCount; ++i) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        this.m_9236_().m_7106_((ParticleOptions)FaunifyParticleTypes.HEALTH.get(), this.m_20185_() + offsetX, this.m_20186_() + (double)this.m_20192_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42405_) {
                if (!this.m_27593_() && this.m_146764_() == 0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_27595_(player);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_() || item != Items.f_42405_ && item != Items.f_41939_) {
                this.toggleSittingState();
                return InteractionResult.SUCCESS;
            }
        }
        if (item == Items.f_41939_ && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21816_(player.m_20148_());
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void toggleSittingState() {
        boolean currentSittingState = this.m_21825_();
        this.m_21837_(!currentSittingState);
        if (!this.m_9236_().f_46443_) {
            if (!currentSittingState) {
                this.m_21573_().m_26573_();
            } else {
                this.m_21839_(false);
                this.m_21573_().m_26569_();
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42405_;
    }

    public static enum Variant implements StringRepresentable
    {
        GREY(0, "grey"),
        BROWN(1, "brown"),
        BLACK(2, "black"),
        WHITE(3, "white");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int p_262571_, String p_262693_) {
            this.id = p_262571_;
            this.name = p_262693_;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int p_262643_) {
            return BY_ID.apply(p_262643_);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public class DustBatheGoal
    extends Goal {
        private final ChinchillaEntity chinchilla;
        private int dustBathTimer = 0;

        public DustBatheGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
        }

        public boolean m_8036_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            return blockState.m_60713_(Blocks.f_49994_);
        }

        public void m_8056_() {
            this.chinchilla.setDustBathing(true);
            this.dustBathTimer = 35;
            this.chinchilla.m_21573_().m_26573_();
        }

        public void m_8037_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            if (!blockState.m_60713_(Blocks.f_49994_)) {
                this.m_8041_();
                return;
            }
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            } else {
                this.chinchilla.setDustBathing(false);
                this.chinchilla.m_9236_().m_46597_(pos, ((Block)FaunifyBlocks.DUST_BLOCK.get()).m_49966_());
                this.chinchilla.m_21573_().m_26573_();
            }
        }

        public boolean m_8045_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            return this.chinchilla.isDustBathing() && blockState.m_60713_(Blocks.f_49994_);
        }

        public void m_8041_() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.m_21573_().m_26573_();
        }
    }

    public class DustBatheSuspiciousGoal
    extends Goal {
        private final ChinchillaEntity chinchilla;
        private int dustBathTimer = 0;
        private int brushStageTimer = 0;
        private boolean isSuspicious = false;
        private boolean hasDroppedItem = false;
        private static final int BRUSH_STAGE_TIME = 5;

        public DustBatheSuspiciousGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
        }

        public boolean m_8036_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            return blockState.m_60713_(Blocks.f_276445_);
        }

        public void m_8056_() {
            this.chinchilla.setDustBathing(true);
            this.dustBathTimer = 35;
            this.chinchilla.m_21573_().m_26573_();
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            this.isSuspicious = blockState.m_60713_(Blocks.f_276445_);
            this.hasDroppedItem = false;
        }

        public void m_8037_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            if (!blockState.m_60713_(Blocks.f_276445_)) {
                this.m_8041_();
                return;
            }
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            } else if (this.isSuspicious) {
                if (this.brushStageTimer > 0) {
                    --this.brushStageTimer;
                } else {
                    this.dustAwaySuspiciousGravel(pos);
                    this.brushStageTimer = 5;
                }
            } else {
                this.chinchilla.m_9236_().m_46597_(pos, ((Block)FaunifyBlocks.DUST_BLOCK.get()).m_49966_());
            }
            if (this.dustBathTimer <= 0 && !this.isSuspicious && !this.hasDroppedItem) {
                this.dropItem(pos);
                this.chinchilla.setDustBathing(false);
                this.hasDroppedItem = true;
            }
        }

        public boolean m_8045_() {
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            BlockState blockState = this.chinchilla.m_9236_().m_8055_(pos);
            return this.chinchilla.isDustBathing() && blockState.m_60713_(Blocks.f_276445_);
        }

        public void m_8041_() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.m_21573_().m_26573_();
        }

        private void dustAwaySuspiciousGravel(BlockPos pos) {
            Player nearestPlayer;
            BrushableBlockEntity blockEntity;
            ServerLevel serverLevel;
            BlockState state;
            Level level = this.chinchilla.m_9236_();
            if (level instanceof ServerLevel && (state = (serverLevel = (ServerLevel)level).m_8055_(pos)).m_60734_() instanceof BrushableBlock && (blockEntity = (BrushableBlockEntity)serverLevel.m_7702_(pos)) != null && (nearestPlayer = (Player)serverLevel.m_8795_(player -> (double)player.m_20270_((Entity)this.chinchilla) < 5.0).stream().findFirst().orElse(null)) != null) {
                blockEntity.m_276923_(serverLevel.m_46467_(), nearestPlayer, Direction.UP);
            }
        }

        private void dropItem(BlockPos pos) {
            Level level = this.chinchilla.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack itemToDrop = this.getRandomItem();
                if (!itemToDrop.m_41619_()) {
                    ItemEntity itemEntity = new ItemEntity((Level)serverLevel, this.chinchilla.m_20185_(), this.chinchilla.m_20186_(), this.chinchilla.m_20189_(), itemToDrop);
                    serverLevel.m_7967_((Entity)itemEntity);
                }
            }
        }

        private ItemStack getRandomItem() {
            int randomChance = this.chinchilla.m_217043_().m_188503_(6);
            if (randomChance == 0) {
                switch (this.chinchilla.m_217043_().m_188503_(24)) {
                    case 0: {
                        return new ItemStack((ItemLike)Items.f_42539_);
                    }
                    case 1: {
                        return new ItemStack((ItemLike)Items.f_42424_);
                    }
                    case 2: {
                        return new ItemStack((ItemLike)Items.f_42535_);
                    }
                    case 3: {
                        return new ItemStack((ItemLike)Items.f_42405_);
                    }
                    case 4: {
                        return new ItemStack((ItemLike)Items.f_42404_);
                    }
                    case 5: {
                        return new ItemStack((ItemLike)Items.f_42401_);
                    }
                    case 6: {
                        return new ItemStack((ItemLike)Items.f_151081_);
                    }
                    case 7: {
                        return new ItemStack((ItemLike)Items.f_151076_);
                    }
                    case 8: {
                        return new ItemStack((ItemLike)Items.f_42536_);
                    }
                    case 9: {
                        return new ItemStack((ItemLike)Items.f_42538_);
                    }
                    case 10: {
                        return new ItemStack((ItemLike)Items.f_42655_);
                    }
                    case 11: {
                        return new ItemStack((ItemLike)Items.f_151080_);
                    }
                    case 12: {
                        return new ItemStack((ItemLike)Items.f_42587_);
                    }
                    case 13: {
                        return new ItemStack((ItemLike)Items.f_42618_);
                    }
                    case 14: {
                        return new ItemStack((ItemLike)Items.f_42616_);
                    }
                    case 15: {
                        return new ItemStack((ItemLike)Items.f_42413_);
                    }
                    case 16: {
                        return new ItemStack((ItemLike)Items.f_151078_);
                    }
                    case 17: {
                        return new ItemStack((ItemLike)Items.f_42460_);
                    }
                    case 18: {
                        return new ItemStack((ItemLike)Items.f_42494_);
                    }
                    case 19: {
                        return new ItemStack((ItemLike)Items.f_42733_);
                    }
                    case 20: {
                        return new ItemStack((ItemLike)Items.f_42180_);
                    }
                    case 21: {
                        return new ItemStack((ItemLike)Items.f_243963_);
                    }
                    case 22: {
                        return new ItemStack((ItemLike)Items.f_42190_);
                    }
                    case 23: {
                        return new ItemStack((ItemLike)Items.f_42186_);
                    }
                    case 24: {
                        return new ItemStack((ItemLike)Items.f_42182_);
                    }
                    case 25: {
                        return new ItemStack((ItemLike)Items.f_244406_);
                    }
                    case 26: {
                        return new ItemStack((ItemLike)Items.f_42178_);
                    }
                    case 27: {
                        return new ItemStack((ItemLike)Items.f_42179_);
                    }
                    case 28: {
                        return new ItemStack((ItemLike)Items.f_41866_);
                    }
                    case 29: {
                        return new ItemStack((ItemLike)Items.f_41983_);
                    }
                    case 30: {
                        return new ItemStack((ItemLike)Items.f_42187_);
                    }
                }
                return ItemStack.f_41583_;
            }
            randomChance = this.chinchilla.m_217043_().m_188503_(3);
            if (randomChance == 0) {
                switch (this.chinchilla.m_217043_().m_188503_(11)) {
                    case 0: {
                        return new ItemStack((ItemLike)Items.f_279650_);
                    }
                    case 1: {
                        return new ItemStack((ItemLike)Items.f_279619_);
                    }
                    case 2: {
                        return new ItemStack((ItemLike)Items.f_283830_);
                    }
                    case 3: {
                        return new ItemStack((ItemLike)Items.f_279584_);
                    }
                    case 4: {
                        return new ItemStack((ItemLike)Items.f_279623_);
                    }
                    case 5: {
                        return new ItemStack((ItemLike)Items.f_279606_);
                    }
                    case 6: {
                        return new ItemStack((ItemLike)Items.f_276433_);
                    }
                    case 7: {
                        return new ItemStack((ItemLike)Items.f_279598_);
                    }
                    case 8: {
                        return new ItemStack((ItemLike)Items.f_276465_);
                    }
                    case 9: {
                        return new ItemStack((ItemLike)Items.f_276546_);
                    }
                    case 10: {
                        return new ItemStack((ItemLike)Items.f_279545_);
                    }
                    case 11: {
                        return new ItemStack((ItemLike)Items.f_276612_);
                    }
                }
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = ChinchillaEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (ChinchillaEntity.this.f_20900_ == 0.0f && ChinchillaEntity.this.f_20901_ == 0.0f && ChinchillaEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || ChinchillaEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return ChinchillaEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            ChinchillaEntity.this.setSleeping(false);
            this.countdown = ChinchillaEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            ChinchillaEntity.this.m_21837_(false);
            ChinchillaEntity.this.m_6862_(false);
            ChinchillaEntity.this.setSleeping(true);
            ChinchillaEntity.this.m_21573_().m_26573_();
            ChinchillaEntity.this.m_21566_().m_6849_(ChinchillaEntity.this.m_20185_(), ChinchillaEntity.this.m_20186_(), ChinchillaEntity.this.m_20189_(), 0.0);
        }
    }
}

