/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.block;

import com.leo.mazerooms.world.RoomHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class TriggerBlock
extends Block {
    public TriggerBlock(BlockBehaviour.Properties properties) {
        super(properties.replaceable().noCollission().noLootTable().noOcclusion().isValidSpawn((s, l, p, e) -> false).noTerrainParticles());
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)entity;
        Level level2 = sPlayer.level();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level2;
        ResourceLocation dimensionName = sLevel.dimension().location();
        if (!dimensionName.getNamespace().equalsIgnoreCase("mazerooms")) {
            return;
        }
        RoomHandler.handlePlayerChunkChange(sPlayer, sLevel);
        level.removeBlock(pos, false);
        super.entityInside(state, level, pos, entity);
    }
}

