/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLPaths;

public class WeightConfigs {
    public static final String CONFIG_FILE = "mazerooms.json5";
    private static WeightConfigs INSTANCE = new WeightConfigs();
    @Expose
    @SerializedName(value="dimension_config")
    public Map<String, DimensionConfig> DIMENSION_CONFIG = Map.of("mazerooms:pool", new DimensionConfig(0.05, 0.75, 0.15, 0.05));

    private WeightConfigs() {
    }

    public static WeightConfigs getInstance() {
        return INSTANCE != null ? INSTANCE : new WeightConfigs();
    }

    public DimensionConfig fromDimension(ResourceKey<Level> dimension) {
        String dim = dimension.location().toString();
        return this.DIMENSION_CONFIG.getOrDefault(dim, new DimensionConfig(0.05, 0.75, 0.15, 0.05));
    }

    public void load() {
        block9: {
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
            Path configPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE);
            File file = configPath.toFile();
            try {
                if (!file.exists()) {
                    System.out.println("Configuration file does not exist. Creating a new one.");
                    this.saveDefaultConfig(file, gson);
                    break block9;
                }
                try (JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));){
                    INSTANCE = (WeightConfigs)gson.fromJson(jsonReader, WeightConfigs.class);
                    if (INSTANCE == null) {
                        throw new JsonSyntaxException("Parsed configuration is null.");
                    }
                }
            }
            catch (JsonSyntaxException | IOException e) {
                System.err.println("Invalid configuration file. Regenerating default config.");
                this.saveDefaultConfig(file, gson);
            }
        }
    }

    private void saveDefaultConfig(File file, Gson gson) {
        try (FileWriter writer = new FileWriter(file);){
            if (INSTANCE == null) {
                INSTANCE = new WeightConfigs();
            }
            gson.toJson((Object)INSTANCE, WeightConfigs.class, (Appendable)writer);
            System.out.println("Default configuration file created successfully.");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default configuration file.", e);
        }
    }

    public record DimensionConfig(@Expose @SerializedName(value="dead_end_chance") double one, @Expose @SerializedName(value="hallway_chance") double two, @Expose @SerializedName(value="t_room_chance") double three, @Expose @SerializedName(value="intersection_chance") double four) {
    }
}

