/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.data;

import com.leo.mazerooms.data.WallDirection;
import com.leo.mazerooms.init.ModAttachmentTypes;
import com.leo.mazerooms.util.ListUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public record MazeData(boolean generated, List<WallDirection> walls) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MazeData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mazerooms", (String)"maze_data"));
    public static final MazeData NEW_DATA = new MazeData(false, ListUtil.of(new WallDirection[0]));
    public static final Codec<MazeData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.fieldOf("generated").forGetter(d -> d.generated), (App)WallDirection.CODEC.listOf().fieldOf("walls").forGetter(d -> d.walls)).apply((Applicative)inst, MazeData::new));

    public static MazeData getOrCreateData(ChunkAccess chunk) {
        if (!chunk.hasData(ModAttachmentTypes.MAZE_DATA_ATTACHMENT)) {
            chunk.setData(ModAttachmentTypes.MAZE_DATA_ATTACHMENT, (Object)NEW_DATA);
        }
        return (MazeData)chunk.getData(ModAttachmentTypes.MAZE_DATA_ATTACHMENT);
    }

    public int getExitCount() {
        return this.walls().size();
    }

    public boolean isCorner() {
        if (this.getExitCount() != 2) {
            return false;
        }
        for (WallDirection dir : this.walls) {
            if (this.hasOpposite(dir)) {
                return false;
            }
            if (!this.hasClockwise(dir) && !this.hasCounterClockwise(dir)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDirection(WallDirection dir) {
        return this.walls.contains((Object)dir);
    }

    public boolean hasClockwise(WallDirection dir) {
        return this.hasDirection(dir.clockwise());
    }

    public boolean hasOpposite(WallDirection dir) {
        return this.hasDirection(dir.opposite());
    }

    public boolean hasCounterClockwise(WallDirection dir) {
        return this.hasDirection(dir.counterClockwise());
    }

    public boolean isLeft() {
        if (!this.isCorner()) {
            return false;
        }
        for (WallDirection dir : this.walls) {
            if (this.hasClockwise(dir)) {
                return false;
            }
            if (!this.hasCounterClockwise(dir)) continue;
            return true;
        }
        return false;
    }

    public static ChunkAccess[] getNearbyChunks(ChunkAccess chunk, Level level) {
        if (level == null) {
            return null;
        }
        ChunkPos def = chunk.getPos();
        ChunkPos north = new ChunkPos(def.x, def.z - 1);
        ChunkPos east = new ChunkPos(def.x + 1, def.z);
        ChunkPos south = new ChunkPos(def.x, def.z + 1);
        ChunkPos west = new ChunkPos(def.x - 1, def.z);
        boolean northA = level.hasChunk(north.x, north.z);
        boolean southA = level.hasChunk(south.x, south.z);
        boolean eastA = level.hasChunk(east.x, east.z);
        boolean westA = level.hasChunk(west.x, west.z);
        LevelChunk northD = northA ? level.getChunk(north.x, north.z) : null;
        LevelChunk southD = southA ? level.getChunk(south.x, south.z) : null;
        LevelChunk eastD = eastA ? level.getChunk(east.x, east.z) : null;
        LevelChunk westD = westA ? level.getChunk(west.x, west.z) : null;
        return new ChunkAccess[]{northD, eastD, southD, westD};
    }

    public static MazeData[] getNearbyChunkData(ChunkAccess chunk, Level level) {
        if (level == null) {
            return new MazeData[]{NEW_DATA, NEW_DATA, NEW_DATA, NEW_DATA};
        }
        MazeData[] toRet = new MazeData[]{NEW_DATA, NEW_DATA, NEW_DATA, NEW_DATA};
        ChunkAccess[] nearbyChunks = MazeData.getNearbyChunks(chunk, level);
        for (int i = 0; i < nearbyChunks.length; ++i) {
            ChunkAccess c = nearbyChunks[i];
            if (c == null) continue;
            toRet[i] = MazeData.getOrCreateData(c);
        }
        return toRet;
    }

    public static ChunkAccess getChunkFromDirection(ChunkAccess current, WallDirection direction, ServerLevel level) {
        ChunkPos currentPos = current.getPos();
        ChunkPos neighborPos = switch (direction) {
            default -> throw new MatchException(null, null);
            case WallDirection.NORTH -> new ChunkPos(currentPos.x, currentPos.z - 1);
            case WallDirection.SOUTH -> new ChunkPos(currentPos.x, currentPos.z + 1);
            case WallDirection.WEST -> new ChunkPos(currentPos.x - 1, currentPos.z);
            case WallDirection.EAST -> new ChunkPos(currentPos.x + 1, currentPos.z);
        };
        return level.getChunkSource().getChunk(neighborPos.x, neighborPos.z, false);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

