/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.data;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;

public enum WallDirection implements StringRepresentable
{
    NORTH("north"),
    EAST("east"),
    SOUTH("south"),
    WEST("west");

    public static final Codec<WallDirection> CODEC;
    public final String name;

    private WallDirection(String name) {
        this.name = name;
    }

    public static WallDirection fromName(String name) {
        for (WallDirection dir : WallDirection.values()) {
            if (!dir.name.equalsIgnoreCase(name)) continue;
            return dir;
        }
        return null;
    }

    public static WallDirection fromIndex(int i) {
        return WallDirection.values()[Math.floorMod(i, 4)];
    }

    public WallDirection clockwise() {
        return WallDirection.values()[(this.ordinal() + 1) % 4];
    }

    public WallDirection opposite() {
        return WallDirection.values()[(this.ordinal() + 2) % 4];
    }

    public WallDirection counterClockwise() {
        return WallDirection.values()[(this.ordinal() + 3) % 4];
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(WallDirection::values);
    }
}

