/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.event;

import com.leo.mazerooms.config.ServerConfig;
import com.leo.mazerooms.util.CommonUtils;
import com.leo.mazerooms.world.RoomHandler;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="mazerooms", bus=EventBusSubscriber.Bus.GAME)
public class PoolRoomGenerator {
    public static final ResourceKey<Level> POOL = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)CommonUtils.create("pool"));

    @SubscribeEvent
    public static void onPlayerChangeChunk(EntityEvent.EnteringSection event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)entity;
        if (!event.didChunkChange()) {
            return;
        }
        ResourceLocation dimensionName = sLevel.dimension().location();
        if (!dimensionName.getNamespace().equalsIgnoreCase("mazerooms")) {
            return;
        }
        RoomHandler.handlePlayerChunkChange(sPlayer, sLevel);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!((Boolean)ServerConfig.SPAWN_IN_POOLROOMS.get()).booleanValue()) {
            return;
        }
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (!sLevel.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        sPlayer.teleportTo(sLevel.getServer().getLevel(POOL), 7.5, 3.0, 7.5, 0.0f, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(EntityJoinLevelEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)entity;
        ResourceLocation dimensionName = sLevel.dimension().location();
        if (!dimensionName.getNamespace().equalsIgnoreCase("mazerooms")) {
            return;
        }
        RoomHandler.handleHub((ChunkAccess)sLevel.getChunk(sPlayer.chunkPosition().x, sPlayer.chunkPosition().z), sLevel);
    }
}

