/*
 * Decompiled with CFR 0.152.
 */
package com.leo.mazerooms.world;

import com.leo.mazerooms.config.ServerConfig;
import com.leo.mazerooms.config.WeightConfigs;
import com.leo.mazerooms.data.MazeData;
import com.leo.mazerooms.data.WallDirection;
import com.leo.mazerooms.util.CommonUtils;
import com.leo.mazerooms.util.ListUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RoomHandler {
    private static int wallsCarryOver = 0;

    public static void handlePlayerChunkChange(ServerPlayer player, ServerLevel sLevel) {
        int maxDistance = (Integer)ServerConfig.MAX_CHUNK_DISTANCE.get();
        ChunkPos playerPos = player.chunkPosition();
        HashSet<ChunkPos> processedChunks = new HashSet<ChunkPos>();
        ArrayList<ChunkPos> chunksToCheck = new ArrayList<ChunkPos>();
        for (int dx = -maxDistance; dx <= maxDistance; ++dx) {
            for (int dz = -maxDistance; dz <= maxDistance; ++dz) {
                if (Math.abs(dx) + Math.abs(dz) > maxDistance) continue;
                chunksToCheck.add(new ChunkPos(playerPos.x + dx, playerPos.z + dz));
            }
        }
        chunksToCheck.sort((p, q) -> Math.abs(p.x - playerPos.x) + Math.abs(p.z - playerPos.z) - (Math.abs(q.x - playerPos.x) + Math.abs(q.z - playerPos.z)));
        for (ChunkPos pos : chunksToCheck) {
            LevelChunk chunk;
            if (processedChunks.contains(pos) || (chunk = sLevel.getChunkSource().getChunk(pos.x, pos.z, false)) == null) continue;
            RoomHandler.handleChunk((ChunkAccess)chunk, sLevel, player);
            processedChunks.add(pos);
        }
    }

    public static void handleFutureChunks(ChunkAccess current, ServerLevel sLevel, ServerPlayer player) {
        int posX = current.getPos().x;
        int posZ = current.getPos().z;
        int pX = player.chunkPosition().x;
        int pZ = player.chunkPosition().z;
        if (Math.abs(posX - pX) + Math.abs(posZ - pZ) >= (Integer)ServerConfig.MAX_CHUNK_DISTANCE.get()) {
            return;
        }
        ChunkAccess[] nearbyChunks = MazeData.getNearbyChunks(current, (Level)sLevel);
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        HashSet<ChunkPos> visitedChunks = new HashSet<ChunkPos>();
        for (int i = 0; i < nearbyChunks.length; ++i) {
            ChunkAccess chunk = nearbyChunks[i];
            if (chunk == null) continue;
            MazeData data = MazeData.getOrCreateData(current);
            if (data.generated()) {
                chunks.add(chunk);
                continue;
            }
            WallDirection dir = WallDirection.fromIndex(i);
            if (!data.hasOpposite(dir)) continue;
            chunks.add(chunk);
        }
        while (!chunks.isEmpty()) {
            ChunkAccess ChunkAccess2 = (ChunkAccess)chunks.remove(chunks.size() - 1);
            if (visitedChunks.contains(ChunkAccess2.getPos())) continue;
            visitedChunks.add(ChunkAccess2.getPos());
            RoomHandler.handleChunk(ChunkAccess2, sLevel, player);
        }
    }

    public static void handleHub(ChunkAccess chunk, ServerLevel level) {
        MazeData data = MazeData.getOrCreateData(chunk);
        if (data.generated()) {
            return;
        }
        String dimensionName = level.dimension().location().getPath();
        RoomHandler.placeChunkRoom(chunk, level, CommonUtils.create(dimensionName + "/room_hub"));
        data = new MazeData(false, ListUtil.of(WallDirection.values()));
        CommonUtils.saveData(chunk, data);
    }

    public static void handleChunk(ChunkAccess chunk, ServerLevel level, ServerPlayer player) {
        WallDirection wallDir;
        MazeData data = MazeData.getOrCreateData(chunk);
        if (data.generated()) {
            return;
        }
        if (data.walls().size() >= 4) {
            String dimensionName = level.dimension().location().getPath();
            data = new MazeData(true, ListUtil.of(WallDirection.values()));
            CommonUtils.saveData(chunk, data);
            RoomHandler.placeChunkRoom(chunk, level, CommonUtils.create(dimensionName + "/room_3_0"));
            return;
        }
        ArrayList<WallDirection> walls = new ArrayList<WallDirection>();
        MazeData[] nearbyData = MazeData.getNearbyChunkData(chunk, (Level)level);
        List<WallDirection> possibleWalls = ListUtil.of(WallDirection.values());
        for (int i = 0; i < nearbyData.length; ++i) {
            MazeData sideData = nearbyData[i];
            if (sideData == null || !sideData.generated()) continue;
            WallDirection dir = WallDirection.fromIndex(i);
            if (sideData.hasOpposite(dir) && !walls.contains((Object)dir)) {
                walls.add(dir);
            }
            possibleWalls.remove((Object)dir);
        }
        int numberOfPaths = RoomHandler.getWeightedRandom(WeightConfigs.getInstance().fromDimension((ResourceKey<Level>)level.dimension()), level.random);
        numberOfPaths += wallsCarryOver;
        wallsCarryOver = 0;
        while (numberOfPaths > walls.size() && !possibleWalls.isEmpty()) {
            int wallToOpen = level.random.nextInt(possibleWalls.size());
            wallDir = possibleWalls.get(wallToOpen);
            walls.add(wallDir);
            possibleWalls.remove((Object)wallDir);
        }
        wallsCarryOver = Math.max(0, numberOfPaths - walls.size());
        if (walls.size() == 0) {
            int wallToOpen = level.random.nextInt(4);
            wallDir = WallDirection.values()[wallToOpen];
            walls.add(wallDir);
        }
        data = new MazeData(true, walls);
        CommonUtils.saveData(chunk, data);
        RoomHandler.handleChunkRoom(chunk, level);
    }

    public static void placeChunkRoom(ChunkAccess chunk, ServerLevel level, ResourceLocation room) {
        ChunkPos cPos = chunk.getPos();
        MazeData data = MazeData.getOrCreateData(chunk);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        pos.set(cPos.getMinBlockX(), 0, cPos.getMinBlockZ());
        StructureTemplateManager manager = level.getStructureManager();
        StructureTemplate template = manager.getOrCreate(room);
        BlockPos center = new BlockPos(7, pos.getY(), 7);
        Rotation rot = RoomHandler.getRoomRotation(data);
        BlockPos toUse = pos.immutable();
        BlockPos offset = new BlockPos(0, 0, 0);
        if (!chunk.getPos().equals((Object)new ChunkPos(0, 0))) {
            offset = offset.north(chunk.getPos().z).west(chunk.getPos().x);
            toUse = toUse.offset(offset.getX(), offset.getY(), offset.getZ());
        }
        template.placeInWorld((ServerLevelAccessor)level, toUse, toUse, new StructurePlaceSettings().setRotationPivot(center).setRotation(rot), level.random, 3);
    }

    public static void handleChunkRoom(ChunkAccess chunk, ServerLevel level) {
        RoomHandler.placeChunkRoom(chunk, level, RoomHandler.getRoomToPlace(chunk, level));
    }

    public static Rotation getRoomRotation(MazeData data) {
        if (!data.generated()) {
            return Rotation.NONE;
        }
        WallDirection start = data.walls().get(0).opposite();
        int exitCount = data.getExitCount();
        if (exitCount == 1) {
            return RoomHandler.determineRotation(start);
        }
        if (exitCount == 3) {
            int count = data.walls().stream().map(Enum::ordinal).mapToInt(Integer::intValue).sum();
            return RoomHandler.determineRotation(WallDirection.fromIndex(5 - count));
        }
        if (exitCount == 2) {
            if (data.isCorner()) {
                return data.isLeft() ? RoomHandler.determineRotation(start.counterClockwise()) : RoomHandler.determineRotation(start.clockwise());
            }
            return RoomHandler.determineRotation(start);
        }
        return Rotation.NONE;
    }

    private static Rotation determineRotation(WallDirection dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case WallDirection.NORTH -> Rotation.NONE;
            case WallDirection.EAST -> Rotation.CLOCKWISE_90;
            case WallDirection.SOUTH -> Rotation.CLOCKWISE_180;
            case WallDirection.WEST -> Rotation.COUNTERCLOCKWISE_90;
        };
    }

    public static ResourceLocation getRoomToPlace(ChunkAccess chunk, ServerLevel level) {
        MazeData data = MazeData.getOrCreateData(chunk);
        int roomNumber = Math.toIntExact(data.getExitCount());
        String dimensionName = level.dimension().location().getPath();
        int availableRoomsPerType = ServerConfig.getRoomNumberFromType(data.isCorner() ? 4 : roomNumber);
        int roomType = new Random().nextInt(0, availableRoomsPerType);
        return CommonUtils.create(dimensionName + "/room_" + (roomNumber - 1) + (data.isCorner() ? (data.isLeft() ? "_cc_" : "_c_") : "_") + roomType);
    }

    public static int getWeightedRandom(WeightConfigs.DimensionConfig config, RandomSource random) {
        int[] values = new int[]{1, 2, 3, 4};
        double[] weights = new double[]{config.one(), config.two(), config.three(), config.four()};
        double totalWeight = 0.0;
        for (double weight : weights) {
            totalWeight += weight;
        }
        double[] cumulativeWeights = new double[weights.length];
        double cumulativeSum = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            cumulativeWeights[i] = cumulativeSum += weights[i] / totalWeight;
        }
        double randomValue = random.nextDouble();
        for (int i = 0; i < cumulativeWeights.length; ++i) {
            if (!(randomValue < cumulativeWeights[i])) continue;
            return values[i];
        }
        return values[0];
    }
}

