/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulSuckerEntity
extends AbstractLavaFish
implements GeoEntity {
    private static final EntityDataAccessor<BlockPos> SOULSAND_POS = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> SEEK_SOULSAND_TIMER = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COOLDOWN_TTIMER = SynchedEntityData.m_135353_(SoulSuckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final RawAnimation MOVING_SOULSUCKER = RawAnimation.begin().thenLoop("soulsucker.moving");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Logger LOGGER = LogUtils.getLogger();
    public int suckTimer = 0;
    @Nullable
    protected FishSwimGoal fishSwimGoal;

    public SoulSuckerEntity(EntityType<? extends AbstractLavaFish> p_27523_, Level p_27524_) {
        super(p_27523_, p_27524_);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.f_21345_.m_25352_(1, (Goal)new FindSoulSandGoal3(this));
        this.f_21345_.m_25352_(4, (Goal)this.fishSwimGoal);
        this.fishSwimGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.getCooldownTimer() > 0) {
            this.setSeekSoulSandTimer(this.getSeekSoulSandTimer() - 1);
            this.setCooldownTimer(this.getSeekSoulSandTimer());
        }
        ++this.suckTimer;
        BlockPos blockPos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
        if (this.m_9236_().m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50135_) || this.m_9236_().m_8055_(blockPos).m_60713_(Blocks.f_50135_) && this.m_20077_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20186_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)NDUItems.SOULSUCKER_BUCKET.get());
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundEvents.f_12325_.get();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12404_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12397_;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12398_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "soulsucker.moving", 0, state -> state.setAndContinue(MOVING_SOULSUCKER))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOULSAND_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SEEK_SOULSAND_TIMER, (Object)0);
        this.f_19804_.m_135372_(COOLDOWN_TTIMER, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SoulSandPosX", this.getSoulSandPos().m_123341_());
        pCompound.m_128405_("SoulSandPosY", this.getSoulSandPos().m_123342_());
        pCompound.m_128405_("SoulSandPosZ", this.getSoulSandPos().m_123343_());
        pCompound.m_128405_("seeksoulsandtimer", this.getSeekSoulSandTimer().intValue());
        pCompound.m_128405_("cooldowntimer", this.getCooldownTimer().intValue());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        int i = pCompound.m_128451_("SoulSandPosX");
        int j = pCompound.m_128451_("SoulSandPosY");
        int k = pCompound.m_128451_("SoulSandPosZ");
        this.setSoulsandPos(new BlockPos(i, j, k));
        this.setSeekSoulSandTimer(pCompound.m_128451_("seeksoulsandtimer"));
        this.setCooldownTimer(pCompound.m_128451_("cooldowntimer"));
        super.m_7378_(pCompound);
    }

    public void setSoulsandPos(BlockPos pPos) {
        this.f_19804_.m_135381_(SOULSAND_POS, (Object)pPos);
    }

    public BlockPos getSoulSandPos() {
        return (BlockPos)this.f_19804_.m_135370_(SOULSAND_POS);
    }

    public void setSeekSoulSandTimer(Integer time) {
        this.f_19804_.m_135381_(SEEK_SOULSAND_TIMER, (Object)time);
    }

    public Integer getSeekSoulSandTimer() {
        return (Integer)this.f_19804_.m_135370_(SEEK_SOULSAND_TIMER);
    }

    public void setCooldownTimer(Integer time) {
        this.f_19804_.m_135381_(COOLDOWN_TTIMER, (Object)time);
    }

    public Integer getCooldownTimer() {
        return (Integer)this.f_19804_.m_135370_(COOLDOWN_TTIMER);
    }

    public static boolean checkDistance(BlockPos entityPos, BlockPos blockPos) {
        double z2;
        double z1;
        double z12;
        double y2;
        double y1;
        double y12;
        double x2;
        double x1 = entityPos.m_123341_();
        double x12 = x1 - (x2 = (double)blockPos.m_123341_());
        double disTot = x12 * x12 + (y12 = (y1 = (double)entityPos.m_123342_()) - (y2 = (double)blockPos.m_123342_())) * y12 + (z12 = (z1 = (double)entityPos.m_123343_()) - (z2 = (double)entityPos.m_123343_())) * z12;
        return disTot <= 3.0;
    }

    static class FindSoulSandGoal3
    extends Goal {
        private static final Logger LOGGER = LogUtils.getLogger();
        private final SoulSuckerEntity mob;
        private int i = 0;
        private int counter = 0;
        private int suckCounter = 30;
        private BlockPos lastPos;
        private RandomSource rand = RandomSource.m_216327_();
        public final List<BlockPos> soulSandList = new ArrayList<BlockPos>();
        private boolean stuck;

        public FindSoulSandGoal3(SoulSuckerEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_20077_() && !this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50135_) && this.mob.getSeekSoulSandTimer() == 0;
        }

        public boolean m_8045_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            return this.mob.getSeekSoulSandTimer() == 0;
        }

        public void m_8056_() {
            if (this.mob.m_9236_() instanceof ServerLevel) {
                this.mob.m_21573_().m_26573_();
                for (int x = -5; x < 5; ++x) {
                    for (int y = 0; y < 10; ++y) {
                        for (int z = -5; z < 5; ++z) {
                            double posX = this.mob.m_20183_().m_123341_();
                            double posY = this.mob.m_20183_().m_123342_();
                            double posZ = this.mob.m_20183_().m_123343_();
                            BlockPos blockPos = BlockPos.m_274561_((double)(posX - (double)x), (double)(posY - (double)y), (double)(posZ - (double)z));
                            if (!this.mob.m_9236_().m_8055_(blockPos).m_60713_(Blocks.f_50135_) || !this.mob.m_9236_().m_6425_(blockPos.m_7494_()).m_192917_((Fluid)Fluids.f_76195_) || this.mob.m_9236_().m_6425_(blockPos.m_7495_()).m_192917_((Fluid)Fluids.f_76195_) || !this.mob.m_9236_().m_8055_(blockPos.m_122012_()).m_60713_(Blocks.f_50135_) || !this.mob.m_9236_().m_8055_(blockPos.m_122029_()).m_60713_(Blocks.f_50135_) || !this.mob.m_9236_().m_8055_(blockPos.m_122019_()).m_60713_(Blocks.f_50135_) || !this.mob.m_9236_().m_8055_(blockPos.m_122024_()).m_60713_(Blocks.f_50135_)) continue;
                            this.soulSandList.add(blockPos);
                        }
                    }
                }
                if (this.soulSandList.size() > 0) {
                    this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                } else {
                    this.mob.setSeekSoulSandTimer(500);
                    this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
                    this.mob.fishSwimGoal.m_25751_();
                    this.m_8041_();
                }
            }
        }

        public void m_8041_() {
            BlockPos blockpos = this.mob.getSoulSandPos();
            super.m_8041_();
            this.mob.setSeekSoulSandTimer(500);
            this.mob.setCooldownTimer(this.mob.getSeekSoulSandTimer());
            this.mob.fishSwimGoal.m_25751_();
            this.soulSandList.clear();
            this.suckCounter = 0;
            this.counter = 0;
            this.i = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            this.lastPos = this.mob.m_20183_();
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.m_8041_();
                this.mob.fishSwimGoal.m_25751_();
                return;
            }
            if (!this.mob.m_9236_().m_8055_(this.soulSandList.get(this.i)).m_60713_(Blocks.f_50135_) && this.counter < this.soulSandList.size()) {
                ++this.i;
                ++this.counter;
            }
            if (this.soulSandList.size() == 0 || this.i >= this.soulSandList.size()) {
                this.m_8041_();
                this.mob.fishSwimGoal.m_25751_();
                return;
            }
            if ((this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50135_) || this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7495_()).m_60713_(Blocks.f_50136_)) && SoulSuckerEntity.checkDistance(this.mob.m_20183_(), this.soulSandList.get(this.i))) {
                ++this.suckCounter;
                this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                if (this.suckCounter == 100) {
                    if (!this.mob.m_9236_().m_8055_(this.mob.m_20183_()).m_60713_(Blocks.f_50135_)) {
                        this.mob.m_9236_().m_7731_(this.mob.m_20183_().m_7495_(), Blocks.f_50136_.m_49966_(), 3);
                    } else {
                        this.mob.m_9236_().m_7731_(this.mob.m_20183_(), Blocks.f_50136_.m_49966_(), 3);
                    }
                    this.mob.f_19802_ = 30;
                    ++this.i;
                    ++this.counter;
                }
            } else {
                this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)(this.soulSandList.get(this.i).m_123342_() + 1), (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
            }
            if (this.suckCounter >= 100) {
                if (this.counter < this.soulSandList.size()) {
                    this.mob.m_21573_().m_26519_((double)this.soulSandList.get(this.i).m_123341_(), (double)this.soulSandList.get(this.i).m_123342_() + 0.5, (double)this.soulSandList.get(this.i).m_123343_(), 1.0);
                } else {
                    BlockPos blockPos = new BlockPos(this.mob.m_20183_().m_123341_() + this.rand.m_216339_(-5, 5), this.mob.m_20183_().m_123342_() + this.rand.m_216339_(0, 3), this.mob.m_20183_().m_123343_() + this.rand.m_216339_(-5, 5));
                    if (this.mob.m_9236_().m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76195_)) {
                        this.mob.m_21573_().m_26519_((double)(this.mob.m_20183_().m_123341_() + this.rand.m_216339_(-5, 5)), (double)(this.mob.m_20183_().m_123342_() + this.rand.m_216339_(0, 3)), (double)(this.mob.m_20183_().m_123343_() + this.rand.m_216339_(-5, 5)), 1.0);
                    }
                    this.mob.setSeekSoulSandTimer(500);
                    this.m_8041_();
                }
                this.suckCounter = 0;
            }
        }
    }
}

