/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantHeadBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public abstract class GrowingLavaPlantBlock
extends Block {
    protected final Direction growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    public GrowingLavaPlantBlock(AbstractBlock.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks) {
        super(pProperties);
        this.growthDirection = pGrowthDirection;
        this.shape = pShape;
        this.scheduleFluidTicks = pScheduleFluidTicks;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext pContext) {
        BlockState blockstate = pContext.func_195991_k().func_180495_p(pContext.func_195995_a().func_177972_a(this.growthDirection));
        return !blockstate.func_203425_a((Block)this.getHeadBlock()) && !blockstate.func_203425_a(this.getBodyBlock()) ? this.getStateForPlacement((IWorld)pContext.func_195991_k()) : this.getBodyBlock().func_176223_P();
    }

    public BlockState getStateForPlacement(IWorld pLevel) {
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState pState, IWorldReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.func_177972_a(this.growthDirection.func_176734_d());
        BlockState blockstate = pLevel.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (!this.canAttachToBlock(block)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || blockstate.func_224755_d((IBlockReader)pLevel, blockpos, this.growthDirection);
    }

    public void func_225534_a_(BlockState pState, ServerWorld pLevel, BlockPos pPos, Random pRand) {
        if (!pState.func_196955_c((IWorldReader)pLevel, pPos)) {
            pLevel.func_175655_b(pPos, true);
        }
    }

    protected boolean canAttachToBlock(Block p_230333_1_) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState pState, IBlockReader pLevel, BlockPos pPos, ISelectionContext pContext) {
        return this.shape;
    }

    protected abstract GrowingLavaPlantHeadBlock getHeadBlock();

    protected abstract Block getBodyBlock();
}

