/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public abstract class GrowingLavaPlantHeadBlock
extends GrowingLavaPlantBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208172_Y;
    public static final int MAX_AGE = 25;
    private final double growPerTickProbability;

    protected GrowingLavaPlantHeadBlock(AbstractBlock.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks, double pGrowPerTickProbability) {
        super(pProperties, pGrowthDirection, pShape, pScheduleFluidTicks);
        this.growPerTickProbability = pGrowPerTickProbability;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getStateForPlacement(IWorld pLevel) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(pLevel.func_201674_k().nextInt(25)));
    }

    public boolean func_149653_t(BlockState pState) {
        return (Integer)pState.func_177229_b((Property)AGE) < 25;
    }

    public void func_225542_b_(BlockState pState, ServerWorld pLevel, BlockPos pPos, Random pRandom) {
        BlockPos blockpos;
        if ((Integer)pState.func_177229_b((Property)AGE) < 25 && ForgeHooks.onCropsGrowPre((World)pLevel, (BlockPos)pPos.func_177972_a(this.growthDirection), (BlockState)pLevel.func_180495_p(pPos.func_177972_a(this.growthDirection)), (pRandom.nextDouble() < this.growPerTickProbability ? 1 : 0) != 0) && this.canGrowInto(pLevel.func_180495_p(blockpos = pPos.func_177972_a(this.growthDirection)))) {
            pLevel.func_175656_a(blockpos, (BlockState)pState.func_235896_a_((Property)AGE));
            ForgeHooks.onCropsGrowPost((World)pLevel, (BlockPos)blockpos, (BlockState)pLevel.func_180495_p(blockpos));
        }
    }

    protected BlockState getGrowIntoState(BlockState pState, Random pRandom) {
        return (BlockState)pState.func_235896_a_((Property)AGE);
    }

    public BlockState getMaxAgeState(BlockState p_187439_) {
        return (BlockState)p_187439_.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(25));
    }

    public boolean isMaxAge(BlockState p_187441_) {
        return (Integer)p_187441_.func_177229_b((Property)AGE) == 25;
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState p_153329_, BlockState p_153330_) {
        return p_153330_;
    }

    public BlockState func_196271_a(BlockState pState, Direction pFacing, BlockState pFacingState, IWorld pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.growthDirection.func_176734_d() && !pState.func_196955_c((IWorldReader)pLevel, pCurrentPos)) {
            pLevel.func_205220_G_().func_205360_a(pCurrentPos, (Object)this, 1);
        }
        if (pFacing != this.growthDirection || !pFacingState.func_203425_a((Block)this) && !pFacingState.func_203425_a(this.getBodyBlock())) {
            if (this.scheduleFluidTicks) {
                pLevel.func_205219_F_().func_205360_a(pCurrentPos, (Object)Fluids.field_204547_b, Fluids.field_204547_b.func_205569_a((IWorldReader)pLevel));
            }
            return super.func_196271_a(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return this.updateBodyAfterConvertedFromHead(pState, this.getBodyBlock().func_176223_P());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> pBuilder) {
        pBuilder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_176473_a(IBlockReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return this.canGrowInto(pLevel.func_180495_p(pPos.func_177972_a(this.growthDirection)));
    }

    public boolean func_180670_a(World pLevel, Random pRand, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void func_225535_a_(ServerWorld pLevel, Random pRand, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.func_177972_a(this.growthDirection);
        int i = Math.min((Integer)pState.func_177229_b((Property)AGE) + 1, 25);
        int j = this.getBlocksToGrowWhenBonemealed(pRand);
        for (int k = 0; k < j && this.canGrowInto(pLevel.func_180495_p(blockpos)); ++k) {
            pLevel.func_175656_a(blockpos, (BlockState)pState.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i)));
            blockpos = blockpos.func_177972_a(this.growthDirection);
            i = Math.min(i + 1, 25);
        }
    }

    protected abstract int getBlocksToGrowWhenBonemealed(Random var1);

    protected abstract boolean canGrowInto(BlockState var1);

    @Override
    protected GrowingLavaPlantHeadBlock getHeadBlock() {
        return this;
    }
}

