/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.google.common.collect.Lists;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import java.util.LinkedList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LavaSpongeBlock
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;

    public LavaSpongeBlock(AbstractBlock.Properties p_56796_) {
        super(p_56796_);
    }

    public void func_220082_b(BlockState pState, World pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.func_203425_a(pState.func_177230_c())) {
            this.tryAbsorbLava(pLevel, pPos);
        }
    }

    public void func_220069_a(BlockState pState, World pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        this.tryAbsorbLava(pLevel, pPos);
        super.func_220069_a(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    protected void tryAbsorbLava(World pLevel, BlockPos pPos) {
        if (this.removeLavaBreadthFirstSearch(pLevel, pPos)) {
            pLevel.func_180501_a(pPos, ((Block)NDUBlocks.WET_LAVA_SPONGE.get()).func_176223_P(), 3);
            pLevel.func_217379_c(2001, pPos, Block.func_196246_j((BlockState)Blocks.field_150353_l.func_176223_P()));
        }
    }

    private boolean removeLavaBreadthFirstSearch(World pLevel, BlockPos pPos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pPos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                BlockState blockstate = pLevel.func_180495_p(blockpos1);
                FluidState fluidstate = pLevel.func_204610_c(blockpos1);
                Material material = blockstate.func_185904_a();
                if (!fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) continue;
                if (blockstate.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)pLevel, blockpos1, blockstate) != Fluids.field_204541_a) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                    pLevel.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.field_203243_f && material != Material.field_204868_h) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? pLevel.func_175625_s(blockpos1) : null;
                LavaSpongeBlock.func_220059_a((BlockState)blockstate, (IWorld)pLevel, (BlockPos)blockpos1, (TileEntity)tileentity);
                pLevel.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

