/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity;

import com.scouter.netherdepthsupgrade.entity.LavaAnimal;
import com.scouter.netherdepthsupgrade.entity.ai.FishSwimGoal;
import com.scouter.netherdepthsupgrade.entity.ai.LavaBoundPathNavigation;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLavaFish
extends LavaAnimal {
    public static final Logger LOGGER = LogManager.getLogger((String)"netherdepthsupgrade");
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(AbstractLavaFish.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> JUMPING = EntityDataManager.func_187226_a(AbstractLavaFish.class, (IDataSerializer)DataSerializers.field_187198_h);
    @Nullable
    public FishSwimGoal fishSwimGoal;

    public AbstractLavaFish(EntityType<? extends AbstractLavaFish> p_27461_, World p_27462_) {
        super(p_27461_, p_27462_);
        this.field_70765_h = new FishMoveControl(this);
    }

    protected float func_213348_b(Pose pPose, EntitySize pSize) {
        return pSize.field_220316_b * 0.65f;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0);
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.fromBucket();
    }

    public boolean func_213397_c(double pDistanceToClosestPlayer) {
        return !this.fromBucket() && !this.func_145818_k_();
    }

    public int func_70641_bl() {
        return 8;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
        this.field_70180_af.func_187214_a(JUMPING, (Object)false);
    }

    public boolean fromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_27498_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_27498_);
    }

    public void setIsJumping(boolean isJumping) {
        this.field_70180_af.func_187227_b(JUMPING, (Object)isJumping);
    }

    public boolean getIsJumping() {
        return (Boolean)this.field_70180_af.func_187225_a(JUMPING);
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        pCompound.func_74757_a("FromBucket", this.fromBucket());
        pCompound.func_74757_a("isJumping", this.getIsJumping());
    }

    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
        this.setFromBucket(pCompound.func_74767_n("FromBucket"));
        this.setIsJumping(pCompound.func_74767_n("isJumping"));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.fishSwimGoal = new FishSwimGoal(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(3, (Goal)new FishSwimGoal(this));
        this.fishSwimGoal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected PathNavigator func_175447_b(World pLevel) {
        return new LavaBoundPathNavigation((MobEntity)this, pLevel);
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70613_aW() && this.func_180799_ab()) {
            this.func_213309_a(0.01f, pTravelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(pTravelVector);
        }
    }

    public void func_70636_d() {
        if (this.func_70090_H()) {
            this.func_70097_a(DamageSource.field_76371_c, 4.0f);
        }
        if (!this.func_180799_ab() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    protected ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        if (itemstack.func_77973_b() == Items.field_151129_at && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getBucketItemStack();
            this.saveToBucketTag(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)pPlayer, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                pPlayer.func_184611_a(pHand, itemstack1);
            } else if (!pPlayer.field_71071_by.func_70441_a(itemstack1)) {
                pPlayer.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(pPlayer, pHand);
    }

    public boolean func_230279_az_() {
        return true;
    }

    protected void saveToBucketTag(ItemStack pBucketStack) {
        if (this.func_145818_k_()) {
            pBucketStack.func_200302_a(this.func_200201_e());
        }
    }

    public abstract ItemStack getBucketItemStack();

    protected boolean canRandomSwim() {
        return true;
    }

    protected abstract SoundEvent getFlopSound();

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
    }

    static class FishMoveControl
    extends MovementController {
        private final AbstractLavaFish fish;

        FishMoveControl(AbstractLavaFish p_27501_) {
            super((MobEntity)p_27501_);
            this.fish = p_27501_;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206960_b)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.fish.func_233637_b_(Attributes.field_233821_d_));
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d1 = this.field_75647_c - this.fish.func_226278_cu_();
                double d2 = this.field_75644_d - this.fish.func_226281_cx_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f1, 90.0f);
                }
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }
}

