/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.ai.FollowLavaFlockLeaderGoal;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class AbstractLavaSchoolingFish
extends AbstractLavaFish {
    @Nullable
    private AbstractLavaSchoolingFish leader;
    private int schoolSize = 1;

    public AbstractLavaSchoolingFish(EntityType<? extends AbstractLavaSchoolingFish> p_27523_, World p_27524_) {
        super((EntityType<? extends AbstractLavaFish>)p_27523_, p_27524_);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowLavaFlockLeaderGoal(this));
    }

    @Override
    public int func_70641_bl() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return super.func_70641_bl();
    }

    @Override
    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.func_70089_S();
    }

    public AbstractLavaSchoolingFish startFollowing(AbstractLavaSchoolingFish p_27526_) {
        this.leader = p_27526_;
        p_27526_.addFollower();
        return p_27526_;
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
            this.leader = null;
        }
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.hasFollowers() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.func_70068_e((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.func_70661_as().func_75497_a((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends AbstractLavaSchoolingFish> p_27534_) {
        p_27534_.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p_27538_ -> p_27538_ != this).forEach(p_27536_ -> p_27536_.startFollowing(this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pSpawnData == null) {
            pSpawnData = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(((SchoolSpawnGroupData)pSpawnData).leader);
        }
        return pSpawnData;
    }

    public static class SchoolSpawnGroupData
    implements ILivingEntityData {
        public final AbstractLavaSchoolingFish leader;

        public SchoolSpawnGroupData(AbstractLavaSchoolingFish p_27553_) {
            this.leader = p_27553_;
        }
    }
}

