/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class LavaFishJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7, 10, 11};
    private final AbstractLavaFish lavaAnimal;
    private final int interval;
    private boolean breached;

    public LavaFishJumpGoal(AbstractLavaFish lavaAnimal, int pInterval) {
        this.lavaAnimal = lavaAnimal;
        this.interval = pInterval;
    }

    public boolean func_75250_a() {
        if (this.lavaAnimal.func_70681_au().nextInt(this.interval) != 0) {
            return false;
        }
        Direction direction = this.lavaAnimal.func_184172_bi();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockpos = this.lavaAnimal.func_233580_cy_();
        for (int k : STEPS_TO_CHECK) {
            if (this.lavaIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean lavaIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        BlockPos blockpos = pPos.func_177982_a(pDx * pScale, 0, pDz * pScale);
        return this.lavaAnimal.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b) && !this.lavaAnimal.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        return this.lavaAnimal.field_70170_p.func_180495_p(pPos.func_177982_a(pDx * pScale, 1, pDz * pScale)).func_196958_f() && this.lavaAnimal.field_70170_p.func_180495_p(pPos.func_177982_a(pDx * pScale, 2, pDz * pScale)).func_196958_f();
    }

    public boolean func_75253_b() {
        double d0 = this.lavaAnimal.func_213322_ci().field_72448_b;
        return !(d0 * d0 < (double)0.03f && this.lavaAnimal.field_70125_A != 0.0f && Math.abs(this.lavaAnimal.field_70125_A) < 10.0f && this.lavaAnimal.func_180799_ab() || this.lavaAnimal.func_233570_aj_());
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        Direction direction = this.lavaAnimal.func_184172_bi();
        this.lavaAnimal.func_213317_d(this.lavaAnimal.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 1.1, 0.7, (double)direction.func_82599_e() * 1.1));
        this.lavaAnimal.func_70661_as().func_75499_g();
        this.lavaAnimal.setIsJumping(true);
    }

    public void func_75251_c() {
        this.lavaAnimal.field_70125_A = 0.0f;
        this.lavaAnimal.setIsJumping(false);
        this.lavaAnimal.fishSwimGoal.func_179480_f();
    }

    public void func_75246_d() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.lavaAnimal.field_70170_p.func_204610_c(this.lavaAnimal.func_233580_cy_());
            this.breached = fluidstate.func_206884_a((ITag)FluidTags.field_206960_b);
        }
        if (this.breached && !flag) {
            this.lavaAnimal.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
        }
        Vector3d vec3 = this.lavaAnimal.func_213322_ci();
        if (vec3.field_72448_b * vec3.field_72448_b < (double)0.03f && this.lavaAnimal.field_70125_A != 0.0f) {
            this.lavaAnimal.field_70125_A = MathHelper.func_226167_j_((float)this.lavaAnimal.field_70125_A, (float)0.0f, (float)0.2f);
        } else if (vec3.func_72433_c() > (double)1.0E-5f) {
            double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vec3));
            double d1 = Math.signum(-vec3.field_72448_b) * Math.acos(d0 / vec3.func_72433_c()) * 57.2957763671875;
            this.lavaAnimal.field_70125_A = (float)d1;
        }
    }
}

