/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class LavaSwimNodeEvaluator
extends NodeProcessor {
    private final boolean allowBreaching;
    private final Long2ObjectMap<PathNodeType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public LavaSwimNodeEvaluator(boolean p_77457_) {
        this.allowBreaching = p_77457_;
    }

    public void func_176163_a() {
        super.func_176163_a();
        this.pathTypesByPosCache.clear();
    }

    public PathPoint func_186318_b() {
        return super.func_176159_a(MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5)), MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72339_c));
    }

    public FlaggedPathPoint func_224768_a(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new FlaggedPathPoint(super.func_176159_a(MathHelper.func_76128_c((double)(p_224768_1_ - (double)(this.field_186326_b.func_213311_cf() / 2.0f))), MathHelper.func_76128_c((double)(p_224768_3_ + 0.5)), MathHelper.func_76128_c((double)(p_224768_5_ - (double)(this.field_186326_b.func_213311_cf() / 2.0f)))));
    }

    public int func_222859_a(PathPoint[] p_77483_, PathPoint p_77484_) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            PathPoint node = this.func_176159_a(p_77484_.field_75839_a + direction.func_82601_c(), p_77484_.field_75837_b + direction.func_96559_d(), p_77484_.field_75838_c + direction.func_82599_e());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            p_77483_[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction1.func_176746_e();
            PathPoint node1 = this.func_176159_a(p_77484_.field_75839_a + direction1.func_82601_c() + direction2.func_82601_c(), p_77484_.field_75837_b, p_77484_.field_75838_c + direction1.func_82599_e() + direction2.func_82599_e());
            if (!this.isDiagonalNodeValid(node1, (PathPoint)map.get(direction1), (PathPoint)map.get(direction2))) continue;
            p_77483_[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable PathPoint p_192962_) {
        return p_192962_ != null && !p_192962_.field_75842_i;
    }

    protected boolean isDiagonalNodeValid(@Nullable PathPoint p_192964_, @Nullable PathPoint p_192965_, @Nullable PathPoint p_192966_) {
        return this.isNodeValid(p_192964_) && p_192965_ != null && p_192965_.field_186286_l >= 0.0f && p_192966_ != null && p_192966_.field_186286_l >= 0.0f;
    }

    @Nullable
    protected PathPoint func_176159_a(int pX, int pY, int pZ) {
        float f;
        PathPoint node = null;
        PathNodeType blockpathtypes = this.func_186330_a((IBlockReader)this.field_186326_b.field_70170_p, pX, pY, pZ);
        if ((this.allowBreaching && blockpathtypes == PathNodeType.BREACH || blockpathtypes == PathNodeType.WATER || blockpathtypes == PathNodeType.LAVA) && (f = this.field_186326_b.func_184643_a(blockpathtypes)) >= 0.0f) {
            node = super.func_176159_a(pX, pY, pZ);
            node.field_186287_m = blockpathtypes;
            node.field_186286_l = Math.max(node.field_186286_l, f);
            if (this.field_176169_a.func_204610_c(new BlockPos(pX, pY, pZ)).func_206888_e()) {
                node.field_186286_l += 8.0f;
            }
        }
        return node;
    }

    public PathNodeType func_186319_a(IBlockReader pLevel, int pX, int pY, int pZ, MobEntity pEntityliving, int pXSize, int pYSize, int pZSize, boolean pCanBreakDoors, boolean pCanEnterDoors) {
        return this.func_186330_a(pLevel, pX, pY, pZ);
    }

    public PathNodeType func_186330_a(IBlockReader pLevel, int pX, int pY, int pZ) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = pX; i < pX + this.field_176168_c; ++i) {
            for (int j = pY; j < pY + this.field_176165_d; ++j) {
                int k = pZ;
                if (k >= pZ + this.field_176166_e) continue;
                FluidState fluidstate = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutable.func_181079_c(i, j, k));
                BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i, j, k));
                if (fluidstate.func_206888_e() && blockstate.func_196957_g(pLevel, blockpos$mutable.func_177977_b(), PathType.WATER) && blockstate.func_196958_f()) {
                    return PathNodeType.BREACH;
                }
                return fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) ? PathNodeType.WATER : PathNodeType.BLOCKED;
            }
        }
        BlockState blockstate1 = pLevel.func_180495_p((BlockPos)blockpos$mutable);
        FluidState fluidState1 = pLevel.func_204610_c((BlockPos)blockpos$mutable);
        return fluidState1.func_206884_a((ITag)FluidTags.field_206960_b) ? PathNodeType.WATER : PathNodeType.BLOCKED;
    }
}

