/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.items.LavaFishingRodItem;
import com.scouter.netherdepthsupgrade.loot.NDULootTables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class LavaFishingBobberEntity
extends FishingBobberEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(LavaFishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_BITING = EntityDataManager.func_187226_a(LavaFishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final Random syncronizedRandom = new Random();
    private boolean bitingFish;
    private final int luck;
    private final int lureSpeed;
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private int outOfLavaTime;
    private float fishAngle;
    private boolean openLava = true;
    @Nullable
    private Entity hookedEntity;
    private LavaFishingBobberEntityState currentState = LavaFishingBobberEntityState.FLYING;

    public LavaFishingBobberEntity(FMLPlayMessages.SpawnEntity spawnPacket, World level) {
        super(level.func_217371_b(spawnPacket.getAdditionalData().func_179253_g()), level, 0, 0);
        this.luck = 0;
        this.lureSpeed = 0;
    }

    public LavaFishingBobberEntity(PlayerEntity p_37106_, World level, int luck, int lureSpeed) {
        super(p_37106_, level, luck, lureSpeed);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
        this.func_184212_Q().func_187214_a(DATA_BITING, (Object)false);
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
    }

    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
    }

    public void func_184206_a(DataParameter<?> pKey) {
        if (DATA_HOOKED_ENTITY.equals(pKey)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        if (DATA_BITING.equals(pKey)) {
            this.bitingFish = (Boolean)this.func_184212_Q().func_187225_a(DATA_BITING);
            if (this.bitingFish) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), this.func_213322_ci().field_72449_c);
            }
        }
        super.func_184206_a(pKey);
    }

    private boolean shouldStopFishing(PlayerEntity player) {
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack1 = player.func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof LavaFishingRodItem;
        boolean flag1 = itemstack1.func_77973_b() instanceof LavaFishingRodItem;
        if (!player.field_70128_L && player.func_70089_S() && (flag || flag1) && !(this.func_70068_e((Entity)player) > 1024.0)) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    public void func_70071_h_() {
        this.syncronizedRandom.setSeed(this.func_110124_au().getLeastSignificantBits() ^ this.field_70170_p.func_82737_E());
        this.canUpdate();
        PlayerEntity player = this.func_234606_i_();
        if (player == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing(player)) {
            boolean flag;
            if (this.field_70122_E) {
                ++this.life;
                if (this.life >= 1200) {
                    this.func_70106_y();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.func_233580_cy_();
            FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                f = fluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == LavaFishingBobberEntityState.FLYING) {
                if (this.hookedEntity != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.currentState = LavaFishingBobberEntityState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = LavaFishingBobberEntityState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == LavaFishingBobberEntityState.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.field_70128_L && this.hookedEntity.field_70170_p.func_234923_W_() == this.field_70170_p.func_234923_W_()) {
                            this.func_70107_b(this.hookedEntity.func_226277_ct_(), this.hookedEntity.func_226283_e_(0.8), this.hookedEntity.func_226281_cx_());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = LavaFishingBobberEntityState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == LavaFishingBobberEntityState.BOBBING) {
                    Vector3d vec3 = this.func_213322_ci();
                    double d0 = this.func_226278_cu_() + vec3.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vec3.field_72450_a * 0.9, vec3.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vec3.field_72449_c * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openLava = true;
                    } else {
                        boolean bl2 = this.openLava = this.openLava && this.outOfLavaTime < 10 && this.calculateOpenLava(blockpos);
                    }
                    if (flag) {
                        this.outOfLavaTime = Math.max(0, this.outOfLavaTime - 1);
                        if (this.bitingFish) {
                            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfLavaTime = Math.min(10, this.outOfLavaTime + 1);
                    }
                }
            }
            if (!fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            if (this.currentState == LavaFishingBobberEntityState.FLYING && (this.field_70122_E || this.field_70123_F)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            double d1 = 0.92;
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_226264_Z_();
        }
    }

    private void checkCollision() {
        RayTraceResult hitresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((LavaFishingBobberEntity)this).func_230298_a_(arg_0));
        if (hitresult.func_216346_c() == RayTraceResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((FishingBobberEntity)this, (RayTraceResult)hitresult)) {
            this.func_70227_a(hitresult);
        }
    }

    private boolean calculateOpenLava(BlockPos p_37159_) {
        FishLavaType fishinghook$fishlavatype = FishLavaType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            FishLavaType fishinghook$fishlavatype1 = this.getOpenLavaTypeForArea(p_37159_.func_177982_a(-2, i, -2), p_37159_.func_177982_a(2, i, 2));
            switch (fishinghook$fishlavatype1) {
                case INVALID: {
                    return false;
                }
                case ABOVE_LAVA: {
                    if (fishinghook$fishlavatype != FishLavaType.INVALID) break;
                    return false;
                }
                case INSIDE_LAVA: {
                    if (fishinghook$fishlavatype != FishLavaType.ABOVE_LAVA) break;
                    return false;
                }
            }
            fishinghook$fishlavatype = fishinghook$fishlavatype1;
        }
        return true;
    }

    private FishLavaType getOpenLavaTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.func_218281_b((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenLavaTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : FishLavaType.INVALID).orElse(FishLavaType.INVALID);
    }

    private FishLavaType getOpenLavaTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.field_70170_p.func_180495_p(p_37164_);
        if (!blockstate.func_196958_f()) {
            FluidState fluidstate = blockstate.func_204520_s();
            return fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) && fluidstate.func_206889_d() && blockstate.func_196952_d((IBlockReader)this.field_70170_p, p_37164_).func_197766_b() ? FishLavaType.INSIDE_LAVA : FishLavaType.INVALID;
        }
        return FishLavaType.ABOVE_LAVA;
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerWorld serverlevel = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = p_37146_.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(blockpos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.func_184212_Q().func_187227_b(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)(this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.func_226277_ct_() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d2 = this.func_226281_cx_() + (double)(f2 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = serverlevel.func_180495_p(new BlockPos(d0, d1 - 1.0, d2));
                if (serverlevel.func_180495_p(new BlockPos((int)d0, (int)d1 - 1, (int)d2)).func_185904_a() == Material.field_151587_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverlevel.func_195598_a((IParticleData)ParticleTypes.field_197614_g, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverlevel.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverlevel.func_195598_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_226278_cu_() + 0.5;
                serverlevel.func_195598_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                serverlevel.func_195598_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), d3, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                this.nibble = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
                this.func_184212_Q().func_187227_b(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a((float)f6) * f7) * 0.1;
                double d5 = (float)MathHelper.func_76128_c((double)this.func_226278_cu_()) + 1.0f;
                double d6 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b((float)f6) * f7) * 0.1;
                BlockState blockstate1 = serverlevel.func_180495_p(new BlockPos(d4, d5 - 1.0, d6));
                if (serverlevel.func_180495_p(new BlockPos(d4, d5 - 1.0, d6)).func_185904_a() == Material.field_151587_i) {
                    serverlevel.func_195598_a((IParticleData)ParticleTypes.field_218424_l, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
        }
    }

    public int func_146034_e(ItemStack p_37157_) {
        PlayerEntity player = this.func_234606_i_();
        if (!this.field_70170_p.field_72995_K && player != null && !this.shouldStopFishing(player)) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.hookedEntity != null) {
                this.pullEntity(this.hookedEntity);
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)player, p_37157_, (FishingBobberEntity)this, Collections.emptyList());
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)p_37157_).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + player.func_184817_da());
                lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this.func_234616_v_()).func_216015_a(LootParameters.field_216281_a, (Object)this);
                LootTable loottable = null;
                double d = (float)Math.floor(this.func_174813_aQ().field_72338_b) + 1.0f;
                BlockState blockstate = this.field_70170_p.func_180495_p(new BlockPos(this.func_213303_ch().field_72450_a, d - 1.0, this.func_213303_ch().field_72449_c));
                loottable = blockstate.func_203425_a(Blocks.field_150353_l) ? (this.field_70170_p.func_234923_W_() == World.field_234919_h_ ? Objects.requireNonNull(this.field_70170_p.func_73046_m()).func_200249_aQ().func_186521_a(NDULootTables.NETHER_FISHING) : Objects.requireNonNull(this.field_70170_p.func_73046_m()).func_200249_aQ().func_186521_a(NDULootTables.LAVA_FISHING)) : Objects.requireNonNull(this.field_70170_p.func_73046_m()).func_200249_aQ().func_186521_a(NDULootTables.FAILED_FISHING);
                if (loottable == null) {
                    this.func_70106_y();
                    return 0;
                }
                List list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
                event = new ItemFishedEvent(list, this.field_70122_E ? 2 : 1, (FishingBobberEntity)this);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.func_70106_y();
                    return event.getRodDamage();
                }
                CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)player, p_37157_, (FishingBobberEntity)this, (Collection)list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), itemstack);
                    double d0 = player.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = player.func_226278_cu_() - (this.func_226278_cu_() + 1.0);
                    double d2 = player.func_226281_cx_() - this.func_226281_cx_();
                    double d3 = 0.1;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c((Entity)itementity);
                    player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) continue;
                    player.func_195067_a(Stats.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.field_70122_E) {
                i = 2;
            }
            this.func_70106_y();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    public void func_212361_a(@Nullable Entity pEntity) {
        super.func_212361_a(pEntity);
        this.updateOwnerInfo(this);
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        PlayerEntity playerentity = this.func_234606_i_();
        if (playerentity != null) {
            playerentity.field_71104_cf = null;
        }
    }

    private void updateOwnerInfo(@Nullable LavaFishingBobberEntity p_150148_) {
        PlayerEntity player = this.func_234606_i_();
        if (player != null) {
            player.field_71104_cf = p_150148_;
        }
    }

    private void setHookedEntity(@Nullable Entity entity) {
        this.hookedEntity = entity;
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(entity == null ? 0 : entity.func_145782_y() + 1));
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return (EntityType)NDUEntity.LAVA_BOBBER.get();
    }

    protected void pullEntity(Entity entityPulled) {
        Entity entity = this.func_234616_v_();
        if (entity != null) {
            Vector3d vec3 = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226278_cu_() - this.func_226278_cu_(), entity.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
            entityPulled.func_213317_d(entityPulled.func_213322_ci().func_178787_e(vec3));
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        PlayerEntity player = this.func_234606_i_();
        if (player != null) {
            buffer.func_179252_a(player.func_110124_au());
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }

    static enum FishLavaType {
        ABOVE_LAVA,
        INSIDE_LAVA,
        INVALID;

    }

    static enum LavaFishingBobberEntityState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

