/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import com.scouter.netherdepthsupgrade.entity.NDUMobType;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class LavaPufferfishEntity
extends AbstractLavaFish {
    private static final DataParameter<Integer> PUFF_STATE = EntityDataManager.func_187226_a(LavaPufferfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    int inflateCounter;
    int deflateTimer;
    private static final Predicate<LivingEntity> NO_SPECTATORS_AND_NO_WATER_MOB = p_29634_ -> {
        if (p_29634_ instanceof PlayerEntity && ((PlayerEntity)p_29634_).func_184812_l_()) {
            return false;
        }
        return p_29634_.func_70668_bt() != NDUMobType.LAVA;
    };
    public static final int STATE_SMALL = 0;
    public static final int STATE_MID = 1;
    public static final int STATE_FULL = 2;

    public LavaPufferfishEntity(EntityType<? extends LavaPufferfishEntity> p_29602_, World p_29603_) {
        super((EntityType<? extends AbstractLavaFish>)p_29602_, p_29603_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUFF_STATE, (Object)0);
    }

    public int getPuffState() {
        return (Integer)this.field_70180_af.func_187225_a(PUFF_STATE);
    }

    public void setPuffState(int p_29619_) {
        this.field_70180_af.func_187227_b(PUFF_STATE, (Object)p_29619_);
    }

    public void func_184206_a(DataParameter<?> pKey) {
        if (PUFF_STATE.equals(pKey)) {
            this.func_213323_x_();
        }
        super.func_184206_a(pKey);
    }

    @Override
    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        pCompound.func_74768_a("PuffState", this.getPuffState());
    }

    @Override
    public boolean func_230279_az_() {
        return true;
    }

    @Override
    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
        this.setPuffState(Math.min(pCompound.func_74762_e("PuffState"), 2));
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((IItemProvider)NDUItems.LAVA_PUFFERFISH_BUCKET.get());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PufferfishPuffGoal(this));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.getPuffState() > 0) {
            for (MobEntity mobentity : this.field_70170_p.func_175647_a(MobEntity.class, this.func_174813_aQ().func_186662_g(0.3), NO_SPECTATORS_AND_NO_WATER_MOB)) {
                if (!mobentity.func_70089_S()) continue;
                this.touch(mobentity);
            }
        }
    }

    private void touch(MobEntity pMob) {
        int i = this.getPuffState();
        if (pMob.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(1 + i))) {
            pMob.func_195064_c(new EffectInstance(Effects.field_82731_v, 60 * i, 0));
            this.func_184185_a(SoundEvents.field_203830_gs, 1.0f, 1.0f);
        }
    }

    public void func_70100_b_(PlayerEntity pEntity) {
        int i = this.getPuffState();
        if (pEntity instanceof ServerPlayerEntity && i > 0 && pEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(1 + i))) {
            if (!this.func_174814_R()) {
                ((ServerPlayerEntity)pEntity).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241773_j_, 0.0f));
            }
            pEntity.func_195064_c(new EffectInstance(Effects.field_82731_v, 60 * i, 0));
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203824_gm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203827_gp;
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_203829_gr;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203828_gq;
    }

    public EntitySize func_213305_a(Pose pPose) {
        return super.func_213305_a(pPose).func_220313_a(LavaPufferfishEntity.getScale(this.getPuffState()));
    }

    private static float getScale(int p_29639_) {
        switch (p_29639_) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class PufferfishPuffGoal
    extends Goal {
        private final LavaPufferfishEntity fish;

        public PufferfishPuffGoal(LavaPufferfishEntity p_29642_) {
            this.fish = p_29642_;
        }

        public boolean func_75250_a() {
            List list = this.fish.field_70170_p.func_175647_a(LivingEntity.class, this.fish.func_174813_aQ().func_186662_g(2.0), NO_SPECTATORS_AND_NO_WATER_MOB);
            return !list.isEmpty();
        }

        public void func_75249_e() {
            this.fish.inflateCounter = 1;
            this.fish.deflateTimer = 0;
        }

        public void func_75251_c() {
            this.fish.inflateCounter = 0;
        }
    }
}

