/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.world;

import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.modcompat.ModChecker;
import com.scouter.netherdepthsupgrade.structures.NDUConfiguredStructures;
import com.scouter.netherdepthsupgrade.world.feature.NDUConfiguredFeatures;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NDUGeneration {
    public static final Logger LOGGER = LogManager.getLogger((String)"netherdepthsupgrade");

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void generateFeatures(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.NETHER)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_SEAGRASS_SIMPLE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_KELP);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_SEAGRASS_SLIGHTLY_LESS_SHORT);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_SEAGRASS_SHORT);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_SEAGRASS_MID);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_WARPED_SEAGRASS_TALL);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_VENT);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NDUConfiguredFeatures.CONFIGURED_LAVA_SPONGE);
            event.getGeneration().getStructures().add(() -> NDUConfiguredStructures.CONFIGURED_NETHER_FORTRESS_PIECE);
        }
        NDUGeneration.spawnCreatures(event);
    }

    public static void spawnCreatures(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.NETHER)) {
            List base = event.getSpawns().getSpawner(EntityClassification.WATER_AMBIENT);
            base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.BONEFISH.get(), 8, 1, 5));
            base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.SEARING_COD.get(), 10, 3, 6));
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "soul_sand_valley"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.SOULSUCKER.get(), 10, 1, 2));
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.WITHER_BONEFISH.get(), 5, 1, 3));
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "basalt_deltas"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.OBSIDIAN_FISH.get(), 15, 1, 5));
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.MAGMACUBEFISH.get(), 10, 2, 4));
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "crimson_forest"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.LAVA_PUFFERFISH.get(), 15, 1, 5));
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.WITHER_BONEFISH.get(), 3, 1, 3));
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "warped_forest"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.LAVA_PUFFERFISH.get(), 15, 1, 5));
            }
            if (!event.getName().equals((Object)new ResourceLocation("minecraft", "crimson_forest")) || !event.getName().equals((Object)new ResourceLocation("minecraft", "warped_forest"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.GLOWDINE.get(), 8, 4, 6));
            }
            if (ModChecker.infernalExpansionPresent && event.getName().equals((Object)new ResourceLocation("infernalexp", "glowstone_canyon"))) {
                base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.GLOWDINE.get(), 8, 4, 6));
            }
            if (ModChecker.biomesYoullGoPresent) {
                if (event.getName().equals((Object)new ResourceLocation("byg", "glowstone_gardens"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.GLOWDINE.get(), 8, 4, 6));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "warped_desert"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.SOULSUCKER.get(), 5, 1, 2));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "wailing_garth"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.SOULSUCKER.get(), 5, 1, 2));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "brimstone_caverns"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.OBSIDIAN_FISH.get(), 7, 1, 5));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "embur_bog"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.MAGMACUBEFISH.get(), 10, 2, 4));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "magma_wastes"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.MAGMACUBEFISH.get(), 10, 2, 4));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "crimson_gardens"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.LAVA_PUFFERFISH.get(), 15, 1, 5));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "sythian_torrids"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.LAVA_PUFFERFISH.get(), 15, 1, 5));
                }
                if (event.getName().equals((Object)new ResourceLocation("byg", "subzero_hypogeal"))) {
                    base.add(new MobSpawnInfo.Spawners((EntityType)NDUEntity.WITHER_BONEFISH.get(), 3, 1, 3));
                }
            }
        }
    }
}

