/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.config;

import blue.endless.jankson.Comment;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Expanded;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.SectionHeader;
import io.wispforest.owo.config.annotation.Sync;
import java.util.ArrayList;
import java.util.List;
import sylenthuntress.thermia.temperature.TemperatureHelper;

@Sync(value=Option.SyncMode.OVERRIDE_CLIENT)
@Modmenu(modId="thermia")
@Config(name="thermia-config", wrapperName="ThermiaConfig")
public class ThermiaConfigModel {
    @SectionHeader(value="clientSection")
    @Sync(value=Option.SyncMode.INFORM_SERVER)
    @Comment(value="\nControls the temperature scale used when displaying temps.\n\nAccepted values are: FAHRENHEIT | CELSIUS | KELVIN\n ")
    public TemperatureHelper.TemperatureScaleDisplay temperatureScaleDisplay = TemperatureHelper.TemperatureScaleDisplay.FAHRENHEIT;
    @Nest
    @Expanded
    @Sync(value=Option.SyncMode.NONE)
    @Comment(value="Settings for displaying climate status effects (hypothermia, hyperthermia)")
    public ClimateEffectDisplay climateEffectDisplay = new ClimateEffectDisplay();
    @SectionHeader(value="temperatureSection")
    @Nest
    @Expanded
    @Comment(value="Which temperature checks to enable")
    public TemperatureChecks temperatureChecks = new TemperatureChecks();
    @Nest
    public EntityTemperature entityTemperature = new EntityTemperature();

    public static class ClimateEffectDisplay {
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean SHOW_HYPOTHERMIA = true;
        public boolean CUSTOM_HYPOTHERMIA_DISPLAY = true;
        @Sync(value=Option.SyncMode.INFORM_SERVER)
        public boolean SHOW_HYPERTHERMIA = true;
        public boolean CUSTOM_HYPERTHERMIA_DISPLAY = true;
    }

    public static class TemperatureChecks {
        public boolean DO_BLOCK = true;
        public boolean DO_FLUID = true;
        public boolean DO_REGIONAL = true;
        public boolean DO_SEASONAL = true;
    }

    public static class EntityTemperature {
        public boolean CAN_FREEZE = true;
        public boolean CAN_OVERHEAT = true;
        @Nest
        public EntityTags entityTags = new EntityTags();

        public static class EntityTags {
            @Expanded
            public List<String> UNAFFECTED_LIST = new ArrayList<String>(List.of("#thermia:climate/unaffected", "#thermia:climate/temperature_immune"));
            public boolean UNAFFECTED_LIST_INVERT = false;
            @Expanded
            public List<String> HAS_FUR_LIST = new ArrayList<String>(List.of("#thermia:climate/has_fur"));
            public boolean HAS_FUR_LIST_INVERT = false;
            @Expanded
            public List<String> HAS_WOOL_LIST = new ArrayList<String>(List.of("#thermia:climate/has_wool"));
            public boolean HAS_WOOL_LIST_INVERT = false;
            @Expanded
            public List<String> UNDEAD_LIST = new ArrayList<String>(List.of("#thermia:climate/is_undead"));
            public boolean UNDEAD_LIST_INVERT = false;
            @Expanded
            public List<String> TEMPERATURE_IMMUNE_LIST = new ArrayList<String>(List.of("#thermia:climate/temperature_immune"));
            public boolean TEMPERATURE_IMMUNE_LIST_INVERT = false;
        }
    }
}

