/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.event;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import sylenthuntress.thermia.registry.ThermiaAttributes;
import sylenthuntress.thermia.registry.ThermiaTags;
import sylenthuntress.thermia.temperature.TemperatureHelper;
import sylenthuntress.thermia.temperature.TemperatureManager;

public class BaseTemperatureAttributes
implements ServerEntityEvents.Load {
    public void onLoad(class_1297 entity, class_3218 world) {
        class_1309 livingEntity;
        block3: {
            block2: {
                if (!(entity instanceof class_1309)) break block2;
                livingEntity = (class_1309)entity;
                if (!entity.method_31747()) break block3;
            }
            return;
        }
        this.calculateBaseTemperature(livingEntity, world);
        this.calculateOffsets(livingEntity, world);
    }

    protected void calculateBaseTemperature(class_1309 entity, class_3218 world) {
        TemperatureManager temperatureManager = TemperatureHelper.getTemperatureManager(entity);
        double baseTemperature = temperatureManager.getBaseTemperature();
        if (baseTemperature != ((class_1320)ThermiaAttributes.BASE_TEMPERATURE.comp_349()).method_6169()) {
            return;
        }
        double ambientTemperature = TemperatureHelper.getAmbientTemperature((class_1937)world, entity.method_24515());
        baseTemperature = (baseTemperature + ambientTemperature) / 2.0;
        class_1324 attributeInstance = entity.method_6127().method_45329(ThermiaAttributes.BASE_TEMPERATURE);
        if (attributeInstance != null) {
            attributeInstance.method_6192(baseTemperature);
        }
    }

    protected void calculateOffsets(class_1309 entity, class_3218 world) {
        class_1324 attributeInstance;
        double coldOffset = entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD);
        double heatOffset = entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD);
        if (coldOffset != ((class_1320)ThermiaAttributes.COLD_OFFSET_THRESHOLD.comp_349()).method_6169()) {
            return;
        }
        if (heatOffset != ((class_1320)ThermiaAttributes.HEAT_OFFSET_THRESHOLD.comp_349()).method_6169()) {
            return;
        }
        class_6880 biome = world.method_23753(entity.method_24515());
        if (biome.method_40220(ConventionalBiomeTags.IS_DRY)) {
            heatOffset += 3.0;
            coldOffset += 3.0;
        }
        if (((class_1959)biome.comp_349()).method_48162(entity.method_24515(), world.method_8615()) == class_1959.class_1963.field_9383) {
            coldOffset += 3.0;
        }
        if (entity.method_5864().method_20210(ThermiaTags.EntityType.HAS_FUR)) {
            coldOffset += 2.0;
            heatOffset -= 1.5;
        }
        if (entity.method_5864().method_20210(ThermiaTags.EntityType.HAS_WOOL)) {
            coldOffset += 4.5;
            heatOffset -= 2.5;
        }
        if (entity.method_5864().method_20210(ThermiaTags.EntityType.UNDEAD)) {
            coldOffset += 10.0;
            heatOffset += 3.0;
        }
        if ((attributeInstance = entity.method_6127().method_45329(ThermiaAttributes.COLD_OFFSET_THRESHOLD)) != null) {
            attributeInstance.method_6192(coldOffset);
        }
        if ((attributeInstance = entity.method_6127().method_45329(ThermiaAttributes.HEAT_OFFSET_THRESHOLD)) != null) {
            attributeInstance.method_6192(heatOffset);
        }
    }
}

