/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import sereneseasons.api.season.Season;
import sylenthuntress.thermia.compat.SereneSeasonsCompatBase;
import sylenthuntress.thermia.registry.ThermiaAttributes;
import sylenthuntress.thermia.temperature.TemperatureHelper;
import sylenthuntress.thermia.temperature.TemperatureManager;
import sylenthuntress.thermia.temperature.TemperatureModifier;
import sylenthuntress.thermia.temperature.TemperatureModifierContainer;

public class TemperatureCommand {
    private static final DynamicCommandExceptionType ENTITY_FAILED_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_54159((String)"commands.temperature.failure.entity.invalid", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType INVALID_MODIFIER_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_54159((String)"commands.temperature.failure.modifier.invalid", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType DUPLICATE_MODIFIER_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_54159((String)"commands.temperature.failure.modifier.duplicate", (Object[])new Object[]{id}));
    private static final DynamicCommandExceptionType NO_MODIFIERS_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_54159((String)"commands.temperature.failure.modifier.none", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType INVALID_POSITION_EXCEPTION = new DynamicCommandExceptionType(position -> class_2561.method_54159((String)"commands.temperature.failure.position.invalid", (Object[])new Object[]{position}));
    private static final DynamicCommandExceptionType UNLOADED_POSITION_EXCEPTION = new DynamicCommandExceptionType(position -> class_2561.method_54159((String)"commands.temperature.failure.position.unloaded", (Object[])new Object[]{position}));
    private static final DynamicCommandExceptionType ODD_EXCEPTION = new DynamicCommandExceptionType(none -> class_2561.method_54159((String)"commands.temperature.failure.what", (Object[])new Object[0]));

    public static void register(CommandNode<class_2168> baseNode) {
        LiteralCommandNode powerNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"temperature").requires(source -> source.method_9259(2))).build();
        ArgumentCommandNode targetNode = class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).build();
        targetNode.addChild(GetEntityTemperatureNode.get());
        targetNode.addChild(SetTemperatureNode.get());
        targetNode.addChild(AddTemperatureNode.get());
        targetNode.addChild(ModifierTemperatureNode.get());
        ArgumentCommandNode positionNode = class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).build();
        positionNode.addChild(GetPositionTemperatureNode.get());
        powerNode.addChild((CommandNode)targetNode);
        powerNode.addChild((CommandNode)positionNode);
        LiteralCommandNode aliasNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"temp").requires(source -> source.method_9259(2))).build();
        powerNode.getChildren().forEach(arg_0 -> ((LiteralCommandNode)aliasNode).addChild(arg_0));
        baseNode.addChild((CommandNode)powerNode);
        baseNode.addChild((CommandNode)aliasNode);
    }

    public static class GetEntityTemperatureNode {
        public static LiteralCommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> GetEntityTemperatureNode.executeCurrent((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 1.0f))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"current").executes(context -> GetEntityTemperatureNode.executeCurrent((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetEntityTemperatureNode.executeCurrent((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unmodified").executes(context -> GetEntityTemperatureNode.executeUnmodified((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetEntityTemperatureNode.executeUnmodified((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"base").executes(context -> GetEntityTemperatureNode.executeBase((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetEntityTemperatureNode.executeBase((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"target").executes(context -> GetEntityTemperatureNode.executeTarget((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetEntityTemperatureNode.executeTarget((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).build();
        }

        private static int executeBase(class_2168 source, class_1297 target, float multiplier) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            double baseTemperature = ((class_1309)target).method_45325(ThermiaAttributes.BASE_TEMPERATURE);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.entity.success", (Object[])new Object[]{"Base", target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), baseTemperature)}), false);
            return (int)(baseTemperature * (double)multiplier * 1000.0);
        }

        private static int executeCurrent(class_2168 source, class_1297 target, float multiplier) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureManager temperatureManager = TemperatureHelper.getTemperatureManager(target);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.entity.success", (Object[])new Object[]{"Current", target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), temperatureManager.getModifiedTemperature())}), false);
            return (int)(temperatureManager.getModifiedTemperature() * (double)multiplier * 1000.0);
        }

        private static int executeRegional(class_2168 source, class_1297 target, float multiplier) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            double regionalTemperature = TemperatureHelper.getRegionalTemperature(target.method_37908(), target.method_24515());
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.position.success", (Object[])new Object[]{"Regional", target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), regionalTemperature)}), false);
            return (int)(regionalTemperature * (double)multiplier * 1000.0);
        }

        private static int executeTarget(class_2168 source, class_1297 target, float multiplier) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            double targetTemperature = TemperatureHelper.getTemperatureManager(target).getTargetTemperature();
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.entity.success", (Object[])new Object[]{"Target", target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), targetTemperature)}), false);
            return (int)(targetTemperature * (double)multiplier * 1000.0);
        }

        private static int executeUnmodified(class_2168 source, class_1297 target, float multiplier) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureManager temperatureManager = TemperatureHelper.getTemperatureManager(target);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.entity.success", (Object[])new Object[]{"Unmodified", target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), temperatureManager.getTemperature())}), false);
            return (int)(temperatureManager.getTemperature() * (double)multiplier * 1000.0);
        }
    }

    public static class SetTemperatureNode {
        public static LiteralCommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> SetTemperatureNode.execute((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))).build();
        }

        private static int execute(class_2168 source, class_1297 target, double value) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureManager temperatureManager = TemperatureHelper.getTemperatureManager(target);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.change.success", (Object[])new Object[]{target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), temperatureManager.getTemperature()), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), value)}), false);
            return (int)(temperatureManager.setTemperature(value) * 1000.0);
        }
    }

    public static class AddTemperatureNode {
        public static LiteralCommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> AddTemperatureNode.execute((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"))))).build();
        }

        private static int execute(class_2168 source, class_1297 target, double value) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureManager temperatureManager = TemperatureHelper.getTemperatureManager(target);
            double newTemperature = temperatureManager.modifyTemperature(value);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.change.success", (Object[])new Object[]{target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), newTemperature - value), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), newTemperature)}), false);
            return (int)(newTemperature * 1000.0);
        }
    }

    public static class ModifierTemperatureNode {
        public static LiteralCommandNode<class_2168> get() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modifier").then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(context -> ModifierTemperatureNode.executeAdd((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), TemperatureModifier.Operation.ADD_VALUE))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9247((String)"add_value").executes(context -> ModifierTemperatureNode.executeAdd((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), TemperatureModifier.Operation.ADD_VALUE)))).then(class_2170.method_9247((String)"add_multiplied_value").executes(context -> ModifierTemperatureNode.executeAdd((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), TemperatureModifier.Operation.ADD_MULTIPLIED_VALUE)))).then(class_2170.method_9247((String)"set_total").executes(context -> ModifierTemperatureNode.executeAdd((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"), TemperatureModifier.Operation.SET_TOTAL))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9257(ModifierTemperatureNode.streamModifiers(class_2186.method_9313((CommandContext)context, (String)"target")), (SuggestionsBuilder)builder)).executes(context -> ModifierTemperatureNode.executeRemove((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"))))).then(class_2170.method_9247((String)"*").executes(context -> ModifierTemperatureNode.executeRemoveAll((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target")))))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9257(ModifierTemperatureNode.streamModifiers(class_2186.method_9313((CommandContext)context, (String)"target")), (SuggestionsBuilder)builder)).executes(context -> ModifierTemperatureNode.executeGet((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), 1.0))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> ModifierTemperatureNode.executeGet((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target"), class_2232.method_9443((CommandContext)context, (String)"id"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale"))))))).build();
        }

        private static int executeRemoveAll(class_2168 source, class_1297 target) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureModifierContainer temperatureModifiers = TemperatureHelper.getTemperatureManager(target).getTemperatureModifiers();
            if (temperatureModifiers.getList().stream().map(TemperatureModifier::id).noneMatch(TemperatureModifier::notGranted)) {
                throw NO_MODIFIERS_EXCEPTION.create((Object)target.method_5477());
            }
            int modifierCount = 0;
            for (class_2960 id : temperatureModifiers.getList().stream().map(TemperatureModifier::id).toList()) {
                if (TemperatureModifier.isGranted(id)) continue;
                temperatureModifiers.removeModifier(id);
                ++modifierCount;
            }
            int displayedModifierCount = modifierCount;
            source.method_9226(() -> class_2561.method_54159((String)"commands.temperature.modifier.remove_all.success", (Object[])new Object[]{displayedModifierCount, target.method_5477()}), false);
            return displayedModifierCount;
        }

        private static int executeRemove(class_2168 source, class_1297 target, class_2960 id) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureModifierContainer temperatureModifiers = TemperatureHelper.getTemperatureManager(target).getTemperatureModifiers();
            if (!temperatureModifiers.hasModifier(id)) {
                throw INVALID_MODIFIER_EXCEPTION.create((Object)id.toString());
            }
            temperatureModifiers.removeModifier(id);
            source.method_9226(() -> class_2561.method_54159((String)"commands.temperature.modifier.remove.success", (Object[])new Object[]{id.toString(), target.method_5477()}), false);
            return 1;
        }

        private static Stream<class_2960> streamModifiers(class_1297 target) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            ArrayList<TemperatureModifier> temperatureModifiers = TemperatureHelper.getTemperatureManager(target).getTemperatureModifiers().getList();
            return temperatureModifiers.stream().map(TemperatureModifier::id).filter(TemperatureModifier::notGranted);
        }

        private static int executeGet(class_2168 source, class_1297 target, class_2960 id, double scale) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureModifierContainer temperatureModifiers = TemperatureHelper.getTemperatureManager(target).getTemperatureModifiers();
            if (!temperatureModifiers.hasModifier(id)) {
                throw INVALID_MODIFIER_EXCEPTION.create((Object)id.toString());
            }
            TemperatureModifier modifier = temperatureModifiers.getModifier(id);
            source.method_9226(() -> class_2561.method_54159((String)("commands.temperature.modifier.get.success." + modifier.operation().ordinal()), (Object[])new Object[]{id.toString(), target.method_5477(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), modifier.operation() == TemperatureModifier.Operation.ADD_VALUE ? modifier.amount() : modifier.amount() * 100.0)}), false);
            return (int)(modifier.amount() * scale * 1000.0);
        }

        private static int executeAdd(class_2168 source, class_1297 target, class_2960 id, double value, TemperatureModifier.Operation operation) throws CommandSyntaxException {
            if (TemperatureHelper.lacksTemperature(target)) {
                throw ENTITY_FAILED_EXCEPTION.create((Object)target.method_5477());
            }
            TemperatureModifierContainer temperatureModifiers = TemperatureHelper.getTemperatureManager(target).getTemperatureModifiers();
            if (temperatureModifiers.hasModifier(id)) {
                throw DUPLICATE_MODIFIER_EXCEPTION.create((Object)id.toString());
            }
            temperatureModifiers.addModifier(new TemperatureModifier(id, value, operation));
            source.method_9226(() -> class_2561.method_54159((String)"commands.temperature.modifier.add.success", (Object[])new Object[]{id.toString(), target.method_5477()}), false);
            return 1;
        }
    }

    public static class GetPositionTemperatureNode {
        public static LiteralCommandNode<class_2168> get() {
            LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(context -> GetPositionTemperatureNode.executeAmbient((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), 1.0f))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ambient").executes(context -> GetPositionTemperatureNode.executeAmbient((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetPositionTemperatureNode.executeAmbient((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"block").executes(context -> GetPositionTemperatureNode.executeBlock((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetPositionTemperatureNode.executeBlock((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fluid").executes(context -> GetPositionTemperatureNode.executeFluid((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetPositionTemperatureNode.executeFluid((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"regional").executes(context -> GetPositionTemperatureNode.executeRegional((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetPositionTemperatureNode.executeRegional((class_2168)context.getSource(), class_2262.method_48299((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale")))))).build();
            if (FabricLoader.getInstance().isModLoaded("sereneseasons")) {
                node.addChild((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"seasonal").executes(context -> GetPositionTemperatureNode.executeSeasonal((class_2168)context.getSource(), 1.0f))).then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> GetPositionTemperatureNode.executeSeasonal((class_2168)context.getSource(), FloatArgumentType.getFloat((CommandContext)context, (String)"scale"))))).build());
            }
            return node;
        }

        private static int executeRegional(class_2168 source, class_2338 blockPos, float multiplier) throws CommandSyntaxException {
            if (!class_1937.method_25953((class_2338)blockPos)) {
                throw INVALID_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            if (!source.method_9225().method_8477(blockPos)) {
                throw UNLOADED_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            double regionalTemperature = TemperatureHelper.getRegionalTemperature((class_1937)source.method_9225(), blockPos);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.position.success", (Object[])new Object[]{"Regional", blockPos.method_23854(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), regionalTemperature)}), false);
            return (int)(regionalTemperature * (double)multiplier * 1000.0);
        }

        private static int executeAmbient(class_2168 source, class_2338 blockPos, float multiplier) throws CommandSyntaxException {
            if (!class_1937.method_25953((class_2338)blockPos)) {
                throw INVALID_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            if (!source.method_9225().method_8477(blockPos)) {
                throw UNLOADED_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            double ambientTemperature = TemperatureHelper.getAmbientTemperature((class_1937)source.method_9225(), blockPos);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.position.success", (Object[])new Object[]{"Ambient", blockPos.method_23854(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), ambientTemperature)}), false);
            return (int)(ambientTemperature * (double)multiplier * 1000.0);
        }

        private static int executeBlock(class_2168 source, class_2338 blockPos, float multiplier) throws CommandSyntaxException {
            if (!class_1937.method_25953((class_2338)blockPos)) {
                throw INVALID_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            if (!source.method_9225().method_8477(blockPos)) {
                throw UNLOADED_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            double blockTemperature = TemperatureHelper.getBlockTemperature((class_1937)source.method_9225(), blockPos);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.position.success", (Object[])new Object[]{"Block", blockPos.method_23854(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), 97.0 + blockTemperature)}), false);
            return (int)(blockTemperature * (double)multiplier * 1000.0);
        }

        private static int executeFluid(class_2168 source, class_2338 blockPos, float multiplier) throws CommandSyntaxException {
            if (!class_1937.method_25953((class_2338)blockPos)) {
                throw INVALID_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            if (!source.method_9225().method_8477(blockPos)) {
                throw UNLOADED_POSITION_EXCEPTION.create((Object)blockPos.method_23854());
            }
            double fluidTemperature = TemperatureHelper.getFluidTemperature((class_1937)source.method_9225(), blockPos);
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.position.success", (Object[])new Object[]{"Fluid", blockPos.method_23854(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), 97.0 + fluidTemperature)}), false);
            return (int)(fluidTemperature * (double)multiplier * 1000.0);
        }

        private static int executeSeasonal(class_2168 source, float multiplier) throws CommandSyntaxException {
            class_3218 world = source.method_9225();
            ServiceLoader<SereneSeasonsCompatBase> loader = ServiceLoader.load(SereneSeasonsCompatBase.class);
            if (loader.findFirst().isEmpty()) {
                throw ODD_EXCEPTION.create((Object)0);
            }
            Season.SubSeason season = loader.findFirst().get().getSeasonState((class_1937)world).getSubSeason();
            double seasonTemperature = TemperatureHelper.getSeasonalTemperature((class_1937)source.method_9225());
            source.method_9226(() -> class_2561.method_43469((String)"commands.temperature.get.season.success", (Object[])new Object[]{season.getSeason().name().toLowerCase(), TemperatureHelper.TemperatureScaleDisplay.convertForClient(source.method_44023(), 97.0 + seasonTemperature)}), false);
            return (int)(seasonTemperature * (double)multiplier * 1000.0);
        }
    }
}

