/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.temperature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1309;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import sylenthuntress.thermia.config.ConfigHelper;
import sylenthuntress.thermia.registry.ThermiaAttachmentTypes;
import sylenthuntress.thermia.registry.ThermiaAttributes;
import sylenthuntress.thermia.temperature.TemperatureHelper;

public record TargetTemperature(double value) {
    public static final TargetTemperature DEFAULT = new TargetTemperature(97.0);
    public static Codec<TargetTemperature> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("target_temperature").forGetter(TargetTemperature::value)).apply((Applicative)instance, TargetTemperature::new));
    public static class_9139<ByteBuf, TargetTemperature> PACKET_CODEC = class_9135.method_56368(CODEC);

    public TargetTemperature(class_1309 entity) {
        this(entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE));
    }

    public static TargetTemperature setValue(double newTemperature) {
        return new TargetTemperature(newTemperature);
    }

    public static double calculateTargetTemperature(class_1309 entity) {
        if (!TemperatureHelper.getTemperatureManager(entity).hasTemperature() || ConfigHelper.isInList$climateUnaffected(entity.method_5864())) {
            double targetTemperature = entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE);
            entity.setAttached(ThermiaAttachmentTypes.TARGET_TEMPERATURE, (Object)TargetTemperature.setValue(targetTemperature));
            return targetTemperature;
        }
        double baseTemperature = entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE);
        double ambientTemperature = TemperatureHelper.getAmbientTemperature(entity.method_37908(), entity.method_24515());
        double targetTemperature = (baseTemperature + ambientTemperature) / 2.0;
        entity.setAttached(ThermiaAttachmentTypes.TARGET_TEMPERATURE, (Object)TargetTemperature.setValue(targetTemperature));
        return targetTemperature;
    }
}

