/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.temperature;

import io.wispforest.owo.config.ConfigSynchronizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ServiceLoader;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_6880;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sylenthuntress.thermia.Thermia;
import sylenthuntress.thermia.access.LivingEntityAccess;
import sylenthuntress.thermia.compat.SereneSeasonsCompatBase;
import sylenthuntress.thermia.registry.ThermiaComponents;
import sylenthuntress.thermia.registry.ThermiaTags;
import sylenthuntress.thermia.registry.data_components.SunBlockingComponent;
import sylenthuntress.thermia.temperature.TemperatureManager;

public abstract class TemperatureHelper {
    public static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("#.###"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public static double getRegionalTemperature(class_1937 world, class_2338 blockPos) {
        double regionalTemperature = 100.0;
        if (!Thermia.CONFIG.temperatureChecks.DO_REGIONAL()) {
            return regionalTemperature;
        }
        class_2874 dimension = world.method_8597();
        class_6880 biome = world.method_23753(blockPos);
        float biomeTemperature = ((class_1959)biome.comp_349()).method_8712();
        if (dimension.comp_644()) {
            biomeTemperature *= 2.0f;
        }
        if (dimension.comp_643() || dimension.method_29960()) {
            return (-1.0f + biomeTemperature) * 5.0f;
        }
        float maxTimeBonus = biome.method_40220(ConventionalBiomeTags.IS_DRY) ? 2.5f : 1.0f;
        float timeBonus = (float)((double)(maxTimeBonus / 2.0f) * Math.cos(world.method_8442(1.0f)) + 1.0);
        if (!world.method_22348(blockPos.method_10069(0, 1, 0))) {
            timeBonus -= maxTimeBonus * 0.5f;
        }
        for (class_1297 entity : world.method_18467(class_1297.class, class_238.method_29968((class_243)class_243.method_24954((class_2382)blockPos.method_10069(0, 6, 0))))) {
            timeBonus -= 0.1f;
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            for (class_1304 slot : class_1304.field_54086) {
                SunBlockingComponent component = (SunBlockingComponent)livingEntity.method_6118(slot).method_57825(ThermiaComponents.SUN_BLOCKING, (Object)SunBlockingComponent.DEFAULT);
                if (!component.slot().method_57286(slot)) continue;
                timeBonus -= component.amount();
            }
        }
        biomeTemperature = biomeTemperature >= 0.0f ? (biomeTemperature *= timeBonus) : -(-biomeTemperature * timeBonus);
        regionalTemperature += (double)((-1.0f + biomeTemperature) * 5.0f);
        return regionalTemperature -= (double)((float)(blockPos.method_10264() - world.method_8615()) * 0.13f);
    }

    public static double getBlockTemperature(class_1937 world, class_2338 blockPos) {
        double blockTemperature = 0.0;
        if (!Thermia.CONFIG.temperatureChecks.DO_BLOCK()) {
            return blockTemperature;
        }
        class_2680 blockState = world.method_8320(blockPos);
        if (((Boolean)blockState.method_61767((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).booleanValue() || blockState.method_51176()) {
            blockTemperature = TemperatureHelper.getFluidTemperature(world, blockPos);
        }
        blockTemperature += (double)((float)world.method_8314(class_1944.field_9282, blockPos) / 4.0f);
        if (!blockState.method_26215()) {
            return blockTemperature;
        }
        for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-4, -4, -4), (class_2338)blockPos.method_10069(4, 4, 4))) {
            class_3610 fluidState;
            blockTemperature += (double)((float)world.method_49804(pos) / 8.0f);
            class_2680 nearbyBlock = world.method_8320(pos);
            if (nearbyBlock.method_26164(ThermiaTags.Block.COLD_BLOCKS)) {
                blockTemperature -= 0.2;
            }
            if (nearbyBlock.method_26164(ThermiaTags.Block.HOT_BLOCKS) || ((Boolean)nearbyBlock.method_61767((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                blockTemperature += 0.2;
            }
            if (!(fluidState = nearbyBlock.method_26227()).method_15767(class_3486.field_15518) || !fluidState.method_15771()) continue;
            blockTemperature += 1.0;
        }
        return blockTemperature;
    }

    public static double getFluidTemperature(class_1937 world, class_2338 blockPos) {
        double fluidTemperature = 0.0;
        if (!Thermia.CONFIG.temperatureChecks.DO_FLUID()) {
            return fluidTemperature;
        }
        for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-1, -2, -1), (class_2338)blockPos.method_10069(1, 2, 1))) {
            class_3610 fluidState = world.method_8316(pos);
            if (fluidState.method_15767(class_3486.field_15518)) {
                fluidTemperature += 1.0;
            }
            if (!((Boolean)world.method_8320(pos).method_61767((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).booleanValue() && !fluidState.method_15767(class_3486.field_15517)) continue;
            if (TemperatureHelper.getRegionalTemperature(world, pos) < 0.0) {
                fluidTemperature -= (double)0.1f;
            }
            fluidTemperature -= (double)0.1f;
        }
        return fluidTemperature;
    }

    public static double getSeasonalTemperature(class_1937 world) {
        double seasonTemperature = 0.0;
        if (!FabricLoader.getInstance().isModLoaded("sereneseasons") || Thermia.CONFIG.temperatureChecks.DO_SEASONAL()) {
            return seasonTemperature;
        }
        ServiceLoader<SereneSeasonsCompatBase> loader = ServiceLoader.load(SereneSeasonsCompatBase.class);
        if (loader.findFirst().isEmpty()) {
            return 0.0;
        }
        ISeasonState seasonState = loader.findFirst().get().getSeasonState(world);
        Season.SubSeason season = seasonState.getSubSeason();
        switch (season) {
            case EARLY_AUTUMN: {
                seasonTemperature = 0.5;
                break;
            }
            case MID_AUTUMN: {
                seasonTemperature = 0.0;
                break;
            }
            case LATE_AUTUMN: {
                seasonTemperature = -0.5;
                break;
            }
            case EARLY_WINTER: {
                seasonTemperature = -1.25;
                break;
            }
            case MID_WINTER: {
                seasonTemperature = -2.0;
                break;
            }
            case LATE_WINTER: {
                seasonTemperature = -1.25;
                break;
            }
            case EARLY_SPRING: {
                seasonTemperature = -0.5;
                break;
            }
            case MID_SPRING: {
                seasonTemperature = 0.0;
                break;
            }
            case LATE_SPRING: {
                seasonTemperature = 0.5;
                break;
            }
            case EARLY_SUMMER: {
                seasonTemperature = 1.25;
                break;
            }
            case MID_SUMMER: {
                seasonTemperature = 2.0;
                break;
            }
            case LATE_SUMMER: {
                seasonTemperature = 1.25;
            }
        }
        return seasonTemperature;
    }

    public static double getAmbientTemperature(class_1937 world, class_2338 blockPos) {
        double regionalTemperature = TemperatureHelper.getRegionalTemperature(world, blockPos);
        double blockTemperature = TemperatureHelper.getBlockTemperature(world, blockPos);
        double seasonalTemperature = TemperatureHelper.getSeasonalTemperature(world);
        return regionalTemperature + blockTemperature + seasonalTemperature;
    }

    public static TemperatureManager getTemperatureManager(class_1309 entity) {
        return ((LivingEntityAccess)entity).thermia$getTemperatureManager();
    }

    public static TemperatureManager getTemperatureManager(class_1297 entity) {
        return TemperatureHelper.getTemperatureManager((class_1309)entity);
    }

    public static boolean lacksTemperature(class_1297 entity) {
        return !entity.method_5709() || !TemperatureHelper.getTemperatureManager(entity).canHaveTemperature();
    }

    public static enum TemperatureScaleDisplay {
        FAHRENHEIT,
        CELSIUS,
        KELVIN;


        public static double celsiusToFahrenheit(double temperature) {
            return temperature * 9.0 / 5.0 + 32.0;
        }

        public static double celsiusToKelvin(double temperature) {
            return temperature + 273.15;
        }

        public static double fahrenheitToCelsius(double temperature) {
            return (temperature - 32.0) * 5.0 / 9.0;
        }

        public static double fahrenheitToKelvin(double temperature) {
            return (temperature - 32.0) * 5.0 / 9.0 + 273.15;
        }

        public static double kelvinToFahrenheit(double temperature) {
            return (temperature - 273.15) * 9.0 / 5.0 + 32.0;
        }

        public static double kelvinToCelsius(double temperature) {
            return temperature - 273.15;
        }

        public static class_2561 convertForClient(class_3222 player, double temperature) {
            TemperatureScaleDisplay temperatureScaleDisplay = (TemperatureScaleDisplay)((Object)ConfigSynchronizer.getClientOptions((class_3222)player, (String)"thermia-config").get(Thermia.CONFIG.keys.temperatureScaleDisplay));
            String temperatureScale = "temperature.scale.fahrenheit";
            switch (temperatureScaleDisplay.ordinal()) {
                case 1: {
                    temperature = TemperatureScaleDisplay.fahrenheitToCelsius(temperature);
                    temperatureScale = "temperature.scale.celsius";
                    break;
                }
                case 2: {
                    temperature = TemperatureScaleDisplay.fahrenheitToKelvin(temperature);
                    temperatureScale = "temperature.scale.kelvin";
                }
            }
            return class_2561.method_43470((String)DECIMAL_FORMAT.format(temperature)).method_10852((class_2561)class_2561.method_43471((String)temperatureScale));
        }
    }
}

