/*
 * Decompiled with CFR 0.152.
 */
package sylenthuntress.thermia.temperature;

import io.wispforest.owo.config.ConfigSynchronizer;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_6880;
import sylenthuntress.thermia.Thermia;
import sylenthuntress.thermia.registry.ThermiaAttachmentTypes;
import sylenthuntress.thermia.registry.ThermiaAttributes;
import sylenthuntress.thermia.registry.ThermiaStatusEffects;
import sylenthuntress.thermia.registry.ThermiaTags;
import sylenthuntress.thermia.temperature.TargetTemperature;
import sylenthuntress.thermia.temperature.Temperature;
import sylenthuntress.thermia.temperature.TemperatureModifier;
import sylenthuntress.thermia.temperature.TemperatureModifierContainer;

public class TemperatureManager {
    protected final class_1309 entity;
    private final TemperatureModifierContainer modifiers = new TemperatureModifierContainer();

    public TemperatureManager(class_1309 livingEntity) {
        this.entity = livingEntity;
    }

    public double setTemperature(double newTemperature) {
        if (!this.canHaveTemperature() || this.entity.method_37908().method_8608()) {
            return ((Temperature)this.entity.getAttachedOrCreate(ThermiaAttachmentTypes.TEMPERATURE, () -> new Temperature(this.entity))).value();
        }
        this.entity.setAttached(ThermiaAttachmentTypes.TEMPERATURE, (Object)Temperature.setValue(newTemperature));
        return ((Temperature)this.entity.getAttachedOrCreate(ThermiaAttachmentTypes.TEMPERATURE, () -> new Temperature(this.entity))).value();
    }

    public double modifyTemperature(double ... inputTemperatures) {
        double newTemperature = this.getTemperature();
        if (this.canHaveTemperature()) {
            for (double inputTemperature : inputTemperatures) {
                newTemperature += inputTemperature;
            }
        }
        return this.setTemperature(newTemperature);
    }

    public double getTargetTemperature() {
        return ((TargetTemperature)this.entity.getAttachedOrElse(ThermiaAttachmentTypes.TARGET_TEMPERATURE, (Object)new TargetTemperature(this.entity))).value();
    }

    public void stepPassiveTemperature() {
        if (!this.canHaveTemperature()) {
            return;
        }
        TargetTemperature.calculateTargetTemperature(this.entity);
        double inputTemperature = this.getTargetTemperature() - this.getTemperature();
        this.modifyTemperature(inputTemperature * 0.0125);
        this.modifyTemperature(this.stepPassiveInteractions());
        this.applyStatus();
    }

    public double[] stepPassiveInteractions() {
        double[] interactionTemperatures = new double[]{0.0, 0.0};
        this.getTemperatureModifiers().removeModifiers(Thermia.modIdentifier("granted/powder_snow"), Thermia.modIdentifier("granted/on_fire"), Thermia.modIdentifier("granted/lava"));
        if (this.entity.field_27857) {
            interactionTemperatures[0] = interactionTemperatures[0] - 0.05;
            this.getTemperatureModifiers().addModifier(new TemperatureModifier(Thermia.modIdentifier("granted/powder_snow"), -10.0, TemperatureModifier.Operation.ADD_VALUE));
        }
        if (this.entity.method_5809() && !this.entity.method_5753()) {
            interactionTemperatures[1] = interactionTemperatures[1] + 0.05;
            this.getTemperatureModifiers().addModifier(new TemperatureModifier(Thermia.modIdentifier("granted/on_fire"), 10.0, TemperatureModifier.Operation.ADD_VALUE));
        }
        if (this.entity.method_55667().method_26227().method_15767(class_3486.field_15518)) {
            interactionTemperatures[1] = interactionTemperatures[1] + 0.1;
            this.getTemperatureModifiers().addModifier(new TemperatureModifier(Thermia.modIdentifier("granted/lava"), 30.0, TemperatureModifier.Operation.ADD_VALUE));
        }
        return interactionTemperatures;
    }

    public void applyStatus() {
        int amplifier = this.getHypothermiaAmplifier();
        if (amplifier >= 0) {
            class_3222 player;
            boolean showIcon;
            class_6880<class_1291> effect = ThermiaStatusEffects.HYPOTHERMIA;
            class_1309 class_13092 = this.entity;
            boolean bl = showIcon = class_13092 instanceof class_3222 && (Boolean)ConfigSynchronizer.getClientOptions((class_3222)(player = (class_3222)class_13092), (String)"thermia-config").get(Thermia.CONFIG.keys.climateEffectDisplay_SHOW_HYPOTHERMIA) != false;
            if (!this.entity.method_6059(effect) || this.entity.method_6112(effect).method_48559()) {
                this.entity.method_26082(new class_1293(effect, -1, amplifier, true, false, showIcon), null);
                this.entity.method_6112(effect).method_52523(this.entity);
            }
        } else {
            amplifier = this.getHyperthermiaAmplifier();
            if (amplifier >= 0) {
                class_3222 player;
                boolean showIcon;
                class_6880<class_1291> effect = ThermiaStatusEffects.HYPERTHERMIA;
                class_1309 class_13093 = this.entity;
                boolean bl = showIcon = class_13093 instanceof class_3222 && (Boolean)ConfigSynchronizer.getClientOptions((class_3222)(player = (class_3222)class_13093), (String)"thermia-config").get(Thermia.CONFIG.keys.climateEffectDisplay_SHOW_HYPERTHERMIA) != false;
                if (!this.entity.method_6059(effect) || this.entity.method_6112(effect).method_48559()) {
                    this.entity.method_26082(new class_1293(effect, -1, amplifier, true, false, showIcon), null);
                    this.entity.method_6112(effect).method_52523(this.entity);
                }
            } else {
                class_6880<class_1291> effect = ThermiaStatusEffects.HYPOTHERMIA;
                if (this.entity.method_6059(effect) && this.entity.method_6112(effect).method_48559()) {
                    this.entity.method_6016(effect);
                }
                if (this.entity.method_6059(effect = ThermiaStatusEffects.HYPERTHERMIA) && this.entity.method_6112(effect).method_48559()) {
                    this.entity.method_6016(effect);
                }
            }
        }
    }

    public double getTemperature() {
        if (!this.hasTemperature()) {
            return this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE);
        }
        return ((Temperature)this.entity.getAttachedOrCreate(ThermiaAttachmentTypes.TEMPERATURE, () -> new Temperature(this.entity))).value();
    }

    public double getBaseTemperature() {
        return this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE);
    }

    public double getModifiedTemperature() {
        if (!this.hasTemperature()) {
            return this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE);
        }
        ArrayList<TemperatureModifier> temperatureModifiers = this.getTemperatureModifiers().getList();
        temperatureModifiers.sort(Comparator.comparingInt(modifier -> modifier.operation().ordinal()));
        double temperature = this.getTemperature();
        for (TemperatureModifier modifier2 : temperatureModifiers) {
            switch (modifier2.operation()) {
                case ADD_VALUE: {
                    temperature += modifier2.amount();
                    break;
                }
                case ADD_MULTIPLIED_VALUE: {
                    temperature += temperature * modifier2.amount();
                    break;
                }
                case SET_TOTAL: {
                    temperature = modifier2.amount();
                }
            }
        }
        return temperature;
    }

    public float distanceFromTemperateBounds(double temperature) {
        double clampedTemperature = Math.clamp(temperature, this.getBaseTemperature() - this.entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD), this.getBaseTemperature() + this.entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD));
        return (float)Math.abs(temperature - clampedTemperature);
    }

    public float normalizeWithinTemperateBounds(double temperature) {
        return this.normalizeWithinTemperateBounds(temperature, this.getBaseTemperature());
    }

    public float normalizeWithinTemperateBounds(double temperature, double baseTemperature) {
        double clampedTemperature = Math.clamp(temperature, baseTemperature - this.entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD), baseTemperature + this.entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD));
        return (float)Math.abs(1.0 - temperature / clampedTemperature);
    }

    public boolean canHaveTemperature() {
        return this.entity.method_5805() && !this.entity.method_5864().method_20210(ThermiaTags.EntityType.TEMPERATURE_IMMUNE);
    }

    public boolean hasTemperature() {
        return !this.entity.method_6059(ThermiaStatusEffects.THERMOREGULATION) && !this.entity.method_7325() && !this.entity.method_56992() && this.canHaveTemperature();
    }

    public TemperatureModifierContainer getTemperatureModifiers() {
        return this.modifiers;
    }

    public boolean isHypothermic() {
        return this.entity.method_6059(ThermiaStatusEffects.HYPOTHERMIA);
    }

    public boolean isHyperthermic() {
        return this.entity.method_6059(ThermiaStatusEffects.HYPERTHERMIA);
    }

    public boolean doColdEffects() {
        return this.isHypothermic() || this.getTargetTemperature() < this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE) - this.entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD) && this.hasTemperature();
    }

    public boolean shouldBlurVision() {
        return this.isHyperthermic();
    }

    public boolean doHeatEffects() {
        return this.isHyperthermic() || this.getTargetTemperature() > this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE) + this.entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD) && this.hasTemperature();
    }

    public int getHypothermiaAmplifier() {
        int amplifier;
        if (this.entity.method_6059(ThermiaStatusEffects.FROST_RESISTANCE) || !this.entity.method_32316() || Thermia.CONFIG.entityTemperature.CAN_FREEZE()) {
            return -1;
        }
        double threshold = this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE) - this.entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD);
        for (amplifier = -1; threshold > this.getModifiedTemperature() && amplifier < 256; threshold -= this.entity.method_45325(ThermiaAttributes.COLD_OFFSET_THRESHOLD), ++amplifier) {
        }
        return amplifier;
    }

    public int getHyperthermiaAmplifier() {
        int amplifier;
        if (this.entity.method_6059(class_1294.field_5918) || this.entity.method_5753() || Thermia.CONFIG.entityTemperature.CAN_OVERHEAT()) {
            return -1;
        }
        double threshold = this.entity.method_45325(ThermiaAttributes.BASE_TEMPERATURE) + this.entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD);
        for (amplifier = -1; threshold < this.getModifiedTemperature() && amplifier < 256; threshold += this.entity.method_45325(ThermiaAttributes.HEAT_OFFSET_THRESHOLD), ++amplifier) {
        }
        return amplifier;
    }
}

