/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChunkEvents {
    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            ChunkLoc location = ChunkLoc.from((LevelChunk)chunk);
            ChunkPollution pollution = WorldData.getChunkPollution(chunk.m_62953_(), location);
            pollution.readFrom(event.getData());
            pollution.setUnloaded(false);
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            ChunkLoc location;
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Level world = chunk.m_62953_();
            ChunkPollution pollution = WorldData.getChunkPollution(world, location = ChunkLoc.from((LevelChunk)chunk));
            if (!pollution.isEmpty()) {
                pollution.writeTo(event.getData());
            }
            if (pollution.isUnloaded()) {
                WorldData.getData(world).removePollutionInfoAt(location);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoaded(ChunkFullyLoadedEvent event) {
        LevelChunk chunk = event.getChunk();
        ServerLevel world = event.getLevel();
        WorldData data = WorldData.getData((Level)world);
        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity tile = (BlockEntity)entry.getValue();
            BlockState state = chunk.m_8055_(pos);
            data.addIfEmitter(world, pos, state, tile);
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Level world = chunk.m_62953_();
            ChunkLoc location = ChunkLoc.from((LevelChunk)chunk);
            WorldData data = WorldData.getData(world);
            ChunkPollution pollution = WorldData.getChunkPollution(world, location);
            pollution.setUnloaded(true);
            if (GameWorld.isServerSide((LevelReader)world)) {
                data.removeTileEmissionsIn(chunk);
            } else {
                data.removePollutionInfoAt(location);
            }
        }
    }
}

