/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPollutionImpacts<L extends AbstractParsableList>
extends AbstractImpacts {
    protected final Map<Pollutant<?>, EnumMap<ImpactType, L>> impactsByPollutant = new ConcurrentHashMap();

    protected Optional<L> getImpactsFor(Pollutant<?> pollutant, ImpactType type) {
        return Optional.ofNullable(this.impactsByPollutant.get(pollutant)).map(impactsBySpread -> (AbstractParsableList)impactsBySpread.get((Object)type));
    }

    public AbstractPollutionImpacts(UnitConfig config) {
        super(config);
    }

    @Override
    protected String getHeadCategory() {
        return "Impacts";
    }

    public void onPostInit() {
        for (EnumMap<ImpactType, L> impactsBySpread : this.impactsByPollutant.values()) {
            for (AbstractParsableList impacts : impactsBySpread.values()) {
                impacts.loadData();
            }
        }
        this.saveConfig();
    }

    protected final void addDefault(Pollutant<?> pollutant, ImpactType type, String ... values) {
        this.getImpactsFor(pollutant, type).ifPresent(impacts -> impacts.addDefaultValues(values));
    }

    protected final void carbon(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.CARBON.get(), type, values);
    }

    protected final void sulfur(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.SULFUR.get(), type, values);
    }

    protected final void dust(ImpactType type, String ... values) {
        this.addDefault(Pollutants.BuiltIn.DUST.get(), type, values);
    }

    public static enum ImpactType implements IForgeEnum
    {
        CONTACT,
        RAIN,
        AIR;

    }
}

