/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.chains.SoilChain;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.config.FluidBlockStateList;
import com.endertech.minecraft.mods.adpother.config.FluidImpactList;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidImpacts
extends AbstractImpacts {
    protected final FluidBlockStateList fluids;
    protected final FluidImpactList impacts;
    protected boolean canSpreadAcrossWater;
    protected boolean canSpreadThroughSoil;
    protected boolean canAffectUnderwaterBlocks;
    protected int maxWaterColumnPressure;
    protected int maxUnderwaterDistance;

    public FluidImpacts(UnitConfig config) {
        super(config);
        this.fluids = new FluidBlockStateList(config, this.getHeadCategory(), "fluids", new String[]{"#forge:acetaldehyde", "#forge:biodiesel", "#forge:bioethanol", "#forge:biofuel", "#forge:chlorine", "#forge:creosote", "#forge:crude_oil", "#forge:deuterium", "#forge:diesel", "#forge:ethanol", "#forge:fuel", "#forge:fusion_fuel", "#forge:gasoline", "#forge:glycerin", "#forge:herbicide", "#forge:heavy_water", "#forge:hydrofluoric_acid", "#forge:kerosene", "#forge:latex", "#forge:lithium", "#forge:lubricant", "#forge:meat", "#forge:methanol", "#forge:napalm", "#forge:naphtha", "#forge:oil", "#forge:petrol", "#forge:petroleum", "#forge:phenolic_resin", "#forge:plantoil", "#forge:polluted_water", "#forge:redstone_acid", "#forge:sewage", "#forge:sludge", "#forge:sulfur_dioxide", "#forge:sulfur_trioxide", "#forge:sulfuric_acid", "#forge:superheated_sodium", "#forge:tritium", "#forge:uranium_hexafluoride", "#forge:uranium_oxide"}, "List of polluting fluids\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n");
        this.impacts = new FluidImpactList(config, this.getHeadCategory(), "impacts", new String[]{"minecraft:dirt_path:* -> minecraft:podzol", "minecraft:dirt:* -> minecraft:coarse_dirt", "minecraft:farmland:* -> minecraft:podzol", "minecraft:grass_block:* -> minecraft:podzol", "minecraft:rooted_dirt:* -> minecraft:coarse_dirt", "minecraft:stone -> minecraft:cobblestone", "minecraft:bamboo:* -> KILL", "minecraft:cactus:* -> KILL", "#minecraft:crops -> KILL", "minecraft:fern:* -> KILL", "minecraft:grass:* -> KILL", "minecraft:large_fern:* -> KILL", "#minecraft:leaves -> KILL", "#minecraft:saplings -> KILL", "#minecraft:small_flowers -> KILL", "minecraft:tall_grass:* -> KILL", "#minecraft:tall_flowers -> KILL", "minecraft:tube_coral -> minecraft:dead_tube_coral", "minecraft:tube_coral_fan -> minecraft:dead_tube_coral_fan", "minecraft:brain_coral -> minecraft:dead_brain_coral", "minecraft:brain_coral_fan -> minecraft:dead_brain_coral_fan", "minecraft:bubble_coral -> minecraft:dead_bubble_coral", "minecraft:bubble_coral_fan -> minecraft:dead_bubble_coral_fan", "minecraft:fire_coral -> minecraft:dead_fire_coral", "minecraft:fire_coral_fan -> minecraft:dead_fire_coral_fan", "minecraft:horn_coral -> minecraft:dead_horn_coral", "minecraft:horn_coral_fan -> minecraft:dead_horn_coral_fan", "minecraft:big_dripleaf:* -> KILL", "minecraft:kelp:* -> KILL", "minecraft:kelp_plant:* -> KILL", "minecraft:lily_pad:* -> KILL", "minecraft:seagrass:* -> KILL", "minecraft:sea_pickle:* -> KILL", "minecraft:small_dripleaf:* -> KILL", "minecraft:tall_seagrass:* -> KILL", "minecraft:water -> POLLUTE"});
    }

    public boolean doImpacts(FluidState fluid, Level level, BlockPos startPos) {
        if (!this.contains(fluid)) {
            return false;
        }
        if (this.tryAffectSurroundings(fluid, level, startPos)) {
            return true;
        }
        if (this.canAffectUnderwaterBlocks && this.tryAffectUnderwaterBlock(fluid, level, startPos)) {
            return true;
        }
        return this.canSpreadAcrossWater && this.tryMoveAround(fluid, level, startPos);
    }

    protected boolean tryAffectBlock(FluidState fluid, Level level, BlockPos pos) {
        BlockState targetBlock = level.m_8055_(pos);
        BlockImpactList.AbstractAction action = this.getAction(fluid, targetBlock).orElse(null);
        if (action != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (action.type == BlockImpactList.ActionType.POLLUTE) {
                Block fluidBlock = fluid.m_76188_().m_60734_();
                if (fluid.m_76170_() && fluidBlock instanceof PollutedWater) {
                    return false;
                }
            }
            return action.perform(serverLevel, pos, targetBlock);
        }
        return false;
    }

    protected boolean tryAffectUnderwaterBlock(FluidState fluid, Level level, BlockPos pos) {
        int distance;
        BlockPos startPos = pos.m_7495_();
        for (distance = 0; distance < this.maxUnderwaterDistance && this.isLiquidWaterBlock((LevelReader)level, startPos.m_6625_(distance)); ++distance) {
        }
        if (distance > 0) {
            return this.tryAffectBlock(fluid, level, startPos.m_6625_(distance));
        }
        return false;
    }

    protected boolean isLiquidWaterBlock(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof LiquidBlock && state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    protected int getPressureAt(Level level, BlockPos pos) {
        Block validBlock = level.m_8055_(pos).m_60734_();
        int pressure = 0;
        int distance = 1;
        while (pressure < this.maxWaterColumnPressure && level.m_8055_(pos.m_6630_(distance)).m_60713_(validBlock)) {
            ++pressure;
            ++distance;
        }
        return pressure;
    }

    protected boolean tryAffectSurroundings(final FluidState fluid, final Level level, BlockPos startPos) {
        int pressure;
        if (this.canSpreadThroughSoil && (pressure = this.getPressureAt(level, startPos)) > 1) {
            int length = pressure + 2 + 1;
            SoilChain chain = new SoilChain(level, startPos, length, startPos.m_6630_(pressure)){

                protected boolean isValidBlock(BlockPos pos) {
                    if (pos.m_123342_() > this.top.m_123342_()) {
                        return false;
                    }
                    BlockState block = this.world.m_8055_(pos);
                    return FluidImpacts.this.getAction(fluid, block).isPresent();
                }

                protected boolean onValidFound(BlockPos pos) {
                    this.affected = FluidImpacts.this.tryAffectBlock(fluid, level, pos);
                    return false;
                }
            };
            chain.build();
            return chain.isAffected();
        }
        for (Direction direction : GameWorld.Directions.of().all().shuffle().toList()) {
            BlockPos pos = startPos.m_121945_(direction);
            if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || !this.tryAffectBlock(fluid, level, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryMoveAround(FluidState fluid, Level level, BlockPos startPos) {
        if (!PollutedWater.isSource((BlockGetter)level, startPos)) {
            return false;
        }
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        GameWorld.getWindAt((Level)level, (BlockPos)startPos).sortDirections(directions);
        for (Direction direction : directions) {
            BlockState target;
            BlockState source;
            BlockPos pos = startPos.m_121945_(direction);
            if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || !this.isLiquidWaterBlock((LevelReader)level, pos) || !GameWorld.isWaterSource((LevelReader)level, (BlockPos)pos) || (source = level.m_8055_(startPos)) == (target = level.m_8055_(pos))) continue;
            return level.m_46597_(startPos, target) && level.m_46597_(pos, source);
        }
        return false;
    }

    public boolean contains(FluidState fluid) {
        if (fluid.m_76178_() || fluid.m_192917_((Fluid)Fluids.f_76193_) || fluid.m_192917_((Fluid)Fluids.f_76192_)) {
            return false;
        }
        return this.fluids.contains(fluid) || this.impacts.contains(fluid);
    }

    public Optional<BlockImpactList.AbstractAction> getAction(FluidState fluid, BlockState block) {
        Optional<BlockImpactList.AbstractAction> action = this.impacts.getActionFor(fluid, block);
        if (action.isPresent()) {
            return action;
        }
        return this.impacts.getCommonAction(block);
    }

    @Override
    protected String getHeadCategory() {
        return "FluidImpacts";
    }

    public List<String> getAllFluids() {
        ArrayList<String> list = new ArrayList<String>();
        this.fluids.listFluids(list);
        this.impacts.listFluids(list);
        return list;
    }

    public void onPostInit() {
        this.canSpreadAcrossWater = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canSpreadAcrossWater", (boolean)true, (String)"Allows polluted water to spread out across the water driven by the wind");
        this.canSpreadThroughSoil = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canSpreadThroughSoil", (boolean)true, (String)"Allows polluting fluids to spread through soil/sand blocks");
        this.canAffectUnderwaterBlocks = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canAffectUnderwaterBlocks", (boolean)true, (String)"Allows polluting fluids floating on the water surface to affect underwater plants and blocks");
        this.maxWaterColumnPressure = UnitConfig.getInt((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"maxWaterColumnPressure", (int)32, (IntBounds)IntBounds.between((Integer)0, (Integer)256), (String)"Limits the ability of polluting fluids to spread through soil blocks.\nNote that higher values may affect game performance.");
        this.maxUnderwaterDistance = UnitConfig.getInt((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"maxUnderwaterDistance", (int)96, (IntBounds)IntBounds.between((Integer)0, (Integer)1024), (String)"Limits the distance at which polluting fluids can affect underwater blocks");
        this.fluids.loadData();
        this.impacts.loadData();
        this.saveConfig();
    }
}

