/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.ReloadableUnitsInit;
import com.endertech.minecraft.mods.adpother.sources.AnimalDeath;
import com.endertech.minecraft.mods.adpother.sources.AnimalFeeding;
import com.endertech.minecraft.mods.adpother.sources.Explosion;
import com.endertech.minecraft.mods.adpother.sources.HostileMobDeath;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.PlayerDeath;
import com.endertech.minecraft.mods.adpother.sources.PlayerEating;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class Sources
extends ReloadableUnitsInit<SourceBase> {
    public final Map<String, ForgeConfigSpec.ConfigValue<Boolean>> enabled = new HashMap<String, ForgeConfigSpec.ConfigValue<Boolean>>();
    public Lazy<Explosion> explosion;
    public Lazy<LavaTouchingWater> lavaTouchingWater;
    public Lazy<AnimalDeath> animalDeath;
    public Lazy<AnimalFeeding> animalFeeding;
    public Lazy<HostileMobDeath> hostileMobDeath;
    public Lazy<PlayerDeath> playerDeath;
    public Lazy<PlayerEating> playerEating;

    public Sources(AbstractForgeMod mod) {
        super(mod);
    }

    protected <T extends SourceBase> Lazy<T> addNew(String name, Factory<T> factory) {
        return this.addUnit(name, () -> (SourceBase)((Object)((Object)factory.create(this.createConfig(name)))));
    }

    protected final void init() {
        this.explosion = this.addNew("Explosion", Explosion::new);
        this.lavaTouchingWater = this.addNew("LavaTouchingWater", LavaTouchingWater::new);
        this.animalDeath = this.addNew("AnimalDeath", AnimalDeath::new);
        this.animalFeeding = this.addNew("AnimalFeeding", AnimalFeeding::new);
        this.hostileMobDeath = this.addNew("HostileMobDeath", HostileMobDeath::new);
        this.playerDeath = this.addNew("PlayerDeath", PlayerDeath::new);
        this.playerEating = this.addNew("PlayerEating", PlayerEating::new);
    }

    public void onPostInit() {
        super.onPostInit();
        this.mapAll().forEach((name, source) -> ((SourceBase)((Object)((Object)source.get()))).setEnabled((Boolean)this.enabled.get(name).get()));
    }

    static interface Factory<T> {
        public T create(UnitConfig var1);
    }
}

