/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.Args;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class Emitter
extends SourceBase
implements IEmitter {
    private final ForgeEmitter emitter;

    public Emitter(UnitConfig config, Properties<?> props) {
        super(config, props);
        this.emitter = new ForgeEmitter(config, props.emitterProps){

            public String getClassCategory() {
                return Emitter.this.getClassCategory();
            }
        };
    }

    public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
        try {
            return super.isActive(nbtSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public String getActiveTag() {
        return this.emitter.getActiveTag();
    }

    public KeyValuePair getIdentityTag() {
        return this.emitter.getIdentityTag();
    }

    public Set<BlockState> getRelatedBlocks() {
        return this.emitter.getRelatedBlocks();
    }

    public IEmitter.Type getType() {
        return this.emitter.getType();
    }

    public boolean hasSeparateRateControl() {
        return false;
    }

    public void onPostInit() {
        this.emitter.onPostInit();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"id", (Object)this.getRelatedId()), Args.get((String)"type", (Object)this.getType()), Args.get((String)"activeTag", (Object)this.getActiveTag()), Args.get((String)"identityTag", (Object)this.getIdentityTag()), Args.get((String)"emissionMap", (Object)this.emissionMap)});
    }

    public static class Properties<T extends Properties<T>>
    extends SourceBase.Properties<T> {
        public Optional<BiFunction<UnitConfig, Properties<?>, Emitter>> factory = Optional.empty();
        public ForgeEmitter.Properties<?> emitterProps;

        protected Properties(Class<T> selfClazz, IEmitter.Type type) {
            super(selfClazz);
            this.emitterProps = ForgeEmitter.Properties.with((IEmitter.Type)type);
        }

        public static Properties<?> tile(String activeTag) {
            return (Properties)((Object)((SourceBase.Properties)((Object)Properties.with(IEmitter.Type.TILE).activeTag(activeTag))).factor(0.016f));
        }

        public static Properties<?> entity(String activeTag) {
            return (Properties)((Object)((SourceBase.Properties)((Object)Properties.with(IEmitter.Type.ENTITY).activeTag(activeTag))).factor(0.016f));
        }

        public static Properties<?> block() {
            return Properties.with(IEmitter.Type.BLOCK);
        }

        public static Properties<?> fuel(String activeTag) {
            return Properties.fuel(activeTag, 1.0f);
        }

        public static Properties<?> fuel(String activeTag, float consumptionFactor) {
            Emissions emissions = Emissions.of();
            AdPother.getInstance().pollutants.streamAll().forEach(pollutant -> emissions.add((Pollutant<?>)((Object)pollutant), consumptionFactor));
            return ((Properties)((Object)Properties.with(IEmitter.Type.FUEL).emissions(emissions))).activeTag(activeTag);
        }

        public static Properties<?> with(IEmitter.Type type) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, type);
            return (Properties)((Object)props.comment(Emission.CATEGORY, "The amount of emissions (in blocks with light density) generated by each update of this emitter.\nThe update frequency depends on the type of the emitter (see the 'type' parameter).\nFor hardcoded emitters with type=FUEL, these values act as fuel consumption MULTIPLIERS.\nSet the value to 0 for disabling emissions from this source.\n"));
        }

        public T emitterProps(ForgeEmitter.Properties<?> emitterProps) {
            this.emitterProps = emitterProps;
            return (T)((Object)((Properties)this.self));
        }

        public T customFactory(BiFunction<UnitConfig, Properties<?>, Emitter> factory) {
            this.factory = Optional.ofNullable(factory);
            return (T)((Object)((Properties)this.self));
        }

        protected void updateId() {
            super.id(this.emitterProps.id);
        }

        public T id(UnitId id) {
            this.emitterProps.id(id);
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T metadata(String metadata) {
            this.emitterProps.metadata(metadata);
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T activeStateHardcoded() {
            this.emitterProps.activeStateHardcoded();
            return (T)((Object)((Properties)this.self));
        }

        public T activeTag(String activeTag) {
            this.emitterProps.activeTag(activeTag);
            return (T)((Object)((Properties)this.self));
        }

        public T identityTag(KeyValuePair identityTag) {
            this.emitterProps.identityTag(identityTag);
            return (T)((Object)((Properties)this.self));
        }

        public T fuelTag(String fuelTag) {
            this.emitterProps.fuelTag(fuelTag);
            return (T)((Object)((Properties)this.self));
        }

        public T relatedBlocks(String ... relatedBlocks) {
            this.emitterProps.relatedBlocks(relatedBlocks);
            return (T)((Object)((Properties)this.self));
        }

        public T stateActive() {
            this.emitterProps.stateActive();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T stateLit() {
            this.emitterProps.stateLit();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }

        public T statePowered() {
            this.emitterProps.statePowered();
            this.updateId();
            return (T)((Object)((Properties)this.self));
        }
    }
}

