/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.RepairMatcher;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class DamageableItem
extends ForgeItem {
    protected final List<UnitId> repairMaterials;
    private final boolean repairCostGrow;
    private final int durability;

    public DamageableItem(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = props.name;
        this.durability = UnitConfig.getInt(this.getConfig(), category, "durability", props.durability, GameBounds.DURABILITY.getIntBounds(), "Defines durability of the item.");
        this.repairMaterials = this.parseRepairMaterials(this.getConfig(), category, props.repairMaterial.toString());
        this.repairCostGrow = UnitConfig.getBool(this.getConfig(), category, "repairCostGrow", false, "If true, repair cost will grow for this item after each repair using an anvil.");
    }

    public int getMaxDamage(ItemStack stack) {
        String key = "maxDamage";
        return stack.m_41782_() && stack.m_41783_().m_128441_(key) ? stack.m_41783_().m_128451_(key) : this.getDurability();
    }

    protected int getDurability() {
        return this.durability;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public void updateDurability(ItemStack stack, ServerPlayer player) {
        stack.m_41784_().m_128405_("maxDamage", this.getDurability());
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    public boolean m_41465_() {
        return true;
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        for (ItemStack stack : new ItemStack[]{event.getLeft(), event.getRight()}) {
            Item item = stack.m_41720_();
            if (!(item instanceof DamageableItem) || ((DamageableItem)item).isRepairCostGrow()) continue;
            DamageableItem.removeRepairPenaltyFor(stack);
        }
    }

    public static void removeRepairPenaltyFor(ItemStack stack) {
        stack.m_41749_("RepairCost");
    }

    public boolean m_6832_(ItemStack stack, ItemStack material) {
        RepairMatcher matcher = RepairMatcher.from(material);
        for (UnitId id : this.repairMaterials) {
            if (!matcher.matches(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isRepairCostGrow() {
        return this.repairCostGrow;
    }

    public Percentage getWearoutPercentage(ItemStack stack) {
        return Percentage.from(stack.m_41773_(), stack.m_41776_());
    }

    protected List<UnitId> parseRepairMaterials(UnitConfig config, String category, String defaultValue) {
        String stringValue = UnitConfig.getStr(config, category, "repair", defaultValue, "Defines anvil repair materials.\nYou can define several materials by separating them with commas (e.g.: minecraft:leather, #wool)");
        ArrayList<UnitId> list = new ArrayList<UnitId>();
        for (String str : stringValue.split(",")) {
            UnitId id;
            if ((str = str.trim()).isEmpty() || !(id = UnitId.from(str)).notEmpty()) continue;
            list.add(id);
        }
        return list;
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeItem.Properties<T> {
        public int durability;
        public UnitId repairMaterial = UnitId.EMPTY;

        public static ForgeItem.Properties<?> of(String name) {
            return new ForgeItem.Properties<ForgeItem.Properties>(ForgeItem.Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public T repairMaterial(UnitId repairMaterial) {
            this.repairMaterial = repairMaterial;
            return (T)((Properties)this.self);
        }

        public T durability(int durability) {
            this.durability = durability;
            this.vanillaProps.m_41503_(durability);
            return (T)((Properties)this.self);
        }
    }
}

