/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.DamageableItem;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EquipmentItem
extends DamageableItem {
    private final EquipmentSlot equipmentSlot;
    @Nullable
    private final SoundEvent equipSound;

    public EquipmentItem(UnitConfig config, Properties<?> props) {
        super(config, (DamageableItem.Properties<?>)props);
        this.equipmentSlot = props.equipmentSlot;
        this.equipSound = props.equipSound;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nullable
    public SoundEvent m_142602_() {
        return this.equipSound;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == this.getEquipmentSlot();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack headSlot = player.m_6844_(this.getEquipmentSlot());
        if (headSlot.m_41619_()) {
            player.m_8061_(this.getEquipmentSlot(), heldStack.m_41777_());
            heldStack.m_41764_(0);
            if (this.m_142602_() != null) {
                player.m_5496_(this.m_142602_(), 1.0f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldStack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
    }

    public static class Properties<T extends Properties<T>>
    extends DamageableItem.Properties<T> {
        public EquipmentSlot equipmentSlot = EquipmentSlot.HEAD;
        public SoundEvent equipSound = null;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public T equipmentSlot(EquipmentSlot slot) {
            this.equipmentSlot = slot;
            return (T)((Properties)this.self);
        }

        public T equipSound(SoundEvent sound) {
            this.equipSound = sound;
            return (T)((Properties)this.self);
        }
    }
}

