/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.client.ChameleonBlockModel;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class ChameleonBlockTile
extends ForgeTile {
    protected BlockState targetBlock = Blocks.f_50016_.m_49966_();

    public ChameleonBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(ChameleonBlockModel.BLOCK_STATE, (Object)this.targetBlock).build();
    }

    public void setTargetBlock(BlockState newState) {
        if (this.targetBlock != newState) {
            this.targetBlock = newState;
            this.syncWithClients();
        }
    }

    public BlockState getTargetBlock() {
        return this.targetBlock;
    }

    @Override
    public void readSharedData(CompoundTag compound) {
        HolderGetter blockGetter = (HolderGetter)Optional.ofNullable(this.f_58857_).map(lvl -> lvl.m_246945_(Registries.f_256747_)).orElse((HolderLookup)BuiltInRegistries.f_256975_.m_255303_());
        this.targetBlock = NbtUtils.m_247651_((HolderGetter)blockGetter, (CompoundTag)compound.m_128469_("target_block"));
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public CompoundTag writeSharedData(CompoundTag compound) {
        if (!this.targetBlock.m_60795_()) {
            compound.m_128365_("target_block", (Tag)NbtUtils.m_129202_((BlockState)this.targetBlock));
        }
        return compound;
    }
}

