/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.client;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import org.dawnoftime.armoroftheages.client.ArmorModelSupplier;
import org.dawnoftime.armoroftheages.client.models.ArmorModel;
import org.jetbrains.annotations.NotNull;

public class ArmorModelProvider {
    private static final class_2960 PLAYER_RESOURCE_LOCATION = new class_2960("minecraft:player");
    private final Supplier<class_5607> layerDefinitionSupplier;
    protected final ArmorModelSupplier modelSupplier;
    private ArmorModel<?> armorModel;
    private final class_5601 modelLayerLocation;
    private final class_2960 resourceLocations;

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier) {
        return new ArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier);
    }

    public static ArmorModelProvider create(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier) {
        return new MixedArmorModelProvider(armorName, slot, modelSupplier, layerDefinitionSupplier, slimLayerDefinitionSupplier);
    }

    private ArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier) {
        this.layerDefinitionSupplier = layerDefinitionSupplier;
        this.modelSupplier = modelSupplier;
        this.modelLayerLocation = new class_5601(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase());
        this.resourceLocations = new class_2960("armoroftheages", "textures/models/armor/" + armorName + ".png");
    }

    @NotNull
    public class_2960 getTexture(class_1297 entity) {
        return this.resourceLocations;
    }

    @NotNull
    public class_5601 getLayerLocation() {
        return this.modelLayerLocation;
    }

    public class_5607 createLayer() {
        return this.layerDefinitionSupplier.get();
    }

    public static boolean isSlim(class_1297 entity) {
        class_742 player;
        return entity instanceof class_742 && (player = (class_742)entity).method_52814().comp_1629() == class_8685.class_7920.field_41122;
    }

    public ArmorModel<?> getArmorModel(class_1297 entity) {
        if (this.armorModel == null) {
            this.armorModel = this.modelSupplier.create(class_310.method_1551().method_31974().method_32072(this.modelLayerLocation), false);
        }
        return this.armorModel;
    }

    public static class MixedArmorModelProvider
    extends ArmorModelProvider {
        private final Supplier<class_5607> slimLayerDefinitionSupplier;
        private final class_5601 slimModelLayerLocation;
        private final class_2960 slimResourceLocations;
        private ArmorModel<?> slimArmorModel;

        private MixedArmorModelProvider(String armorName, class_1304 slot, ArmorModelSupplier modelSupplier, Supplier<class_5607> layerDefinitionSupplier, Supplier<class_5607> slimLayerDefinitionSupplier) {
            super(armorName, slot, modelSupplier, layerDefinitionSupplier);
            this.slimLayerDefinitionSupplier = slimLayerDefinitionSupplier;
            this.slimModelLayerLocation = new class_5601(PLAYER_RESOURCE_LOCATION, armorName + "_" + slot.name().toLowerCase() + "_slim");
            this.slimResourceLocations = new class_2960("armoroftheages", "textures/models/armor/" + armorName + "_slim.png");
        }

        @NotNull
        public class_5601 getSlimLayerLocation() {
            return this.slimModelLayerLocation;
        }

        public class_5607 createSlimLayer() {
            return this.slimLayerDefinitionSupplier.get();
        }

        @Override
        @NotNull
        public class_2960 getTexture(class_1297 entity) {
            return MixedArmorModelProvider.isSlim(entity) ? this.slimResourceLocations : super.getTexture(entity);
        }

        @Override
        public ArmorModel<?> getArmorModel(class_1297 entity) {
            if (ArmorModelProvider.isSlim(entity)) {
                if (this.slimArmorModel == null) {
                    this.slimArmorModel = this.modelSupplier.create(class_310.method_1551().method_31974().method_32072(this.slimModelLayerLocation), true);
                }
                return this.slimArmorModel;
            }
            return super.getArmorModel(entity);
        }
    }
}

