/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.block;

import com.mojang.serialization.MapCodec;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import de.cech12.solarcooker.platform.Services;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SolarCookerBlock
extends AbstractSolarCookerBlock {
    public static final MapCodec<AbstractSolarCookerBlock> CODEC = SolarCookerBlock.simpleCodec(SolarCookerBlock::new);

    public SolarCookerBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return Services.REGISTRY.getNewBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> entityType) {
        return SolarCookerBlock.createTickerHelper(entityType, Constants.SOLAR_COOKER_ENTITY_TYPE.get(), SolarCookerBlockEntity::tick);
    }

    @Override
    protected void interactWith(Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SolarCookerBlockEntity && player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)((SolarCookerBlockEntity)blockEntity));
        }
    }

    public void animateTick(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)BURNING)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.playLocalSound(d0, d1, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1 + 0.6, d2, 0.0, 0.0, 0.0);
        }
    }
}

