/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.blockentity;

import com.google.common.collect.Lists;
import de.cech12.solarcooker.Constants;
import de.cech12.solarcooker.ModTags;
import de.cech12.solarcooker.block.AbstractSolarCookerBlock;
import de.cech12.solarcooker.block.ReflectorBlock;
import de.cech12.solarcooker.block.SolarCookerBlock;
import de.cech12.solarcooker.inventory.SolarCookerContainer;
import de.cech12.solarcooker.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SolarCookerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
LidBlockEntity {
    public static final int CONTAINER_IS_SUNLIT = 0;
    public static final int CONTAINER_COOK_TIME = 1;
    public static final int CONTAINER_COOK_TIME_TOTAL = 2;
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] SLOTS_UP = new int[0];
    protected static final int INPUT = 0;
    protected static final int OUTPUT = 1;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    protected int cookTime;
    protected int cookTimeTotal;
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    protected int reflectorCount = 0;
    protected final RecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipes = new Object2IntOpenHashMap();
    protected RecipeHolder<? extends AbstractCookingRecipe> curRecipe;
    protected ItemStack failedMatch = ItemStack.EMPTY;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (SolarCookerBlockEntity.this.isSunlit()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> SolarCookerBlockEntity.this.cookTime;
                case 2 -> SolarCookerBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 1: {
                    SolarCookerBlockEntity.this.cookTime = value;
                    break;
                }
                case 2: {
                    SolarCookerBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 3;
        }
    };

    public SolarCookerBlockEntity(BlockEntityType<?> tileTypeIn, BlockPos pos, BlockState state, RecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn) {
        super(tileTypeIn, pos, state);
        this.specificRecipeType = specificRecipeTypeIn;
    }

    public SolarCookerBlockEntity(BlockPos pos, BlockState state) {
        this(Constants.SOLAR_COOKER_ENTITY_TYPE.get(), pos, state, Constants.SOLAR_COOKING_RECIPE_TYPE.get());
    }

    @Nonnull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.solarcooker.solar_cooker");
    }

    @Nonnull
    protected AbstractContainerMenu createMenu(int id, @Nonnull Inventory player) {
        return new SolarCookerContainer(this.specificRecipeType, id, player, (Container)this, this.dataAccess);
    }

    private boolean hasShiningBlockAbove() {
        BlockPos checkPos;
        if (this.level != null && !this.level.isClientSide && this.level.getBlockState(checkPos = this.worldPosition.above()).propagatesSkylightDown((BlockGetter)this.level, checkPos)) {
            for (int i = 0; i < 5; ++i) {
                BlockState state = this.level.getBlockState(checkPos = checkPos.above());
                if (state.is(ModTags.Blocks.SOLAR_COOKER_SHINING)) {
                    return true;
                }
                if (state.propagatesSkylightDown((BlockGetter)this.level, checkPos)) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isSunlit() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                return this.hasShiningBlockAbove() || this.level.dimensionType().hasSkyLight() && this.level.isDay() && !this.level.isRaining() && this.level.canSeeSky(this.worldPosition.above());
            }
            return (Boolean)this.getBlockState().getValue((Property)SolarCookerBlock.SUNLIT);
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)provider);
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
    }

    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)provider);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SolarCookerBlockEntity entity) {
        if (level != null) {
            boolean isBurning;
            boolean dirty = false;
            entity.calculateLidAngle();
            boolean isSunlit = entity.isSunlit();
            if (isSunlit && !((ItemStack)entity.items.get(0)).isEmpty()) {
                RecipeHolder<? extends AbstractCookingRecipe> recipe = entity.getRecipe();
                if (entity.canSmelt(recipe)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getRecipeCookTime();
                        if (!level.isClientSide) {
                            entity.smeltItem(recipe);
                            dirty = true;
                        }
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!isSunlit && entity.cookTime > 0) {
                entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            boolean bl = isBurning = entity.cookTime > 0;
            if (!(level.isClientSide || (Boolean)entity.getBlockState().getValue((Property)SolarCookerBlock.BURNING) == isBurning && (Boolean)entity.getBlockState().getValue((Property)SolarCookerBlock.SUNLIT) == isSunlit)) {
                dirty = true;
                entity.level.setBlock(entity.worldPosition, (BlockState)((BlockState)entity.level.getBlockState(entity.worldPosition).setValue((Property)SolarCookerBlock.SUNLIT, (Comparable)Boolean.valueOf(isSunlit))).setValue((Property)SolarCookerBlock.BURNING, (Comparable)Boolean.valueOf(isBurning)), 3);
            }
            if (dirty) {
                entity.setChanged();
            }
        }
    }

    public boolean shouldLidBeOpen() {
        return this.numPlayersUsing > 0 || this.canSmelt(this.getRecipe()) && this.isSunlit();
    }

    private void calculateLidAngle() {
        if (this.level != null) {
            this.prevLidAngle = this.lidAngle;
            boolean shouldLidBeOpen = this.shouldLidBeOpen();
            if (shouldLidBeOpen && this.lidAngle == 0.0f) {
                this.playSound(SoundEvents.CHEST_OPEN);
                if (!this.level.isClientSide) {
                    this.setChanged();
                }
            }
            if (!shouldLidBeOpen && this.lidAngle > 0.0f || shouldLidBeOpen && this.lidAngle < 1.0f) {
                float f1 = this.lidAngle;
                this.lidAngle = shouldLidBeOpen ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                    this.playSound(SoundEvents.CHEST_CLOSE);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.getBlockState().getBlock();
        if (this.level != null && block instanceof SolarCookerBlock) {
            this.level.blockEvent(this.worldPosition, block, 1, this.numPlayersUsing);
        }
    }

    private void playSound(SoundEvent soundIn) {
        if (this.level != null && !this.level.isClientSide) {
            double x = (double)this.worldPosition.getX() + 0.5;
            double y = (double)this.worldPosition.getY() + 0.5;
            double z = (double)this.worldPosition.getZ() + 0.5;
            this.level.playSound(null, x, y, z, soundIn, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    protected boolean canSmelt(@Nullable RecipeHolder<?> recipe) {
        ItemStack recipeOutput;
        if (!((ItemStack)this.items.get(0)).isEmpty() && recipe != null && !(recipeOutput = recipe.value().assemble((Container)this, (HolderLookup.Provider)this.getLevel().registryAccess())).isEmpty()) {
            ItemStack output = (ItemStack)this.items.get(1);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    private void smeltItem(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.value().assemble((Container)this, (HolderLookup.Provider)this.getLevel().registryAccess());
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.isEmpty()) {
                this.items.set(1, (Object)itemstack1.copy());
            } else if (itemstack2.getItem() == itemstack1.getItem()) {
                itemstack2.grow(itemstack1.getCount());
            }
            if (this.level != null && !this.level.isClientSide) {
                this.setRecipeUsed(recipe);
            }
            itemstack.shrink(1);
        }
    }

    protected int getRecipeCookTime() {
        double reflectorFactor;
        RecipeHolder<? extends AbstractCookingRecipe> rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        this.checkForReflectors();
        double d = reflectorFactor = this.reflectorCount > 0 ? 1.0 - (1.0 - Services.CONFIG.getMaxReflectorTimeFactor()) / 4.0 * (double)this.reflectorCount : 1.0;
        if (this.specificRecipeType.getClass().isInstance(((AbstractCookingRecipe)rec.value()).getType())) {
            return (int)((double)((AbstractCookingRecipe)rec.value()).getCookingTime() * reflectorFactor);
        }
        return (int)((double)((AbstractCookingRecipe)rec.value()).getCookingTime() * (Services.CONFIG.getCookTimeFactor() * reflectorFactor));
    }

    protected RecipeHolder<? extends AbstractCookingRecipe> getRecipe() {
        ItemStack input = this.getItem(0);
        if (input.isEmpty() || input == this.failedMatch) {
            return null;
        }
        if (this.level != null && this.curRecipe != null && ((AbstractCookingRecipe)this.curRecipe.value()).matches((Container)this, this.level)) {
            return this.curRecipe;
        }
        RecipeHolder rec = null;
        if (this.level != null && (rec = (RecipeHolder)this.level.getRecipeManager().getRecipeFor(this.specificRecipeType, (Container)this, this.level).orElse(null)) == null && Services.CONFIG.areVanillaRecipesEnabled()) {
            rec = this.level.getRecipeManager().getRecipesFor(Services.CONFIG.getRecipeType(), (Container)this, this.level).stream().filter(abstractCookingRecipe -> Services.CONFIG.isRecipeAllowed(abstractCookingRecipe.id())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : ItemStack.EMPTY;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    private void checkForReflectors() {
        BlockState state;
        this.reflectorCount = 0;
        if (this.level != null && (state = this.level.getBlockState(this.worldPosition)).getBlock() instanceof AbstractSolarCookerBlock) {
            Direction facing = (Direction)state.getValue((Property)AbstractSolarCookerBlock.FACING);
            this.reflectorCount += this.countReflectorsOnSide(facing.getClockWise());
            this.reflectorCount += this.countReflectorsOnSide(facing.getCounterClockWise());
        }
    }

    private int countReflectorsOnSide(Direction direction) {
        int count = 0;
        if (this.level != null) {
            BlockPos blockPos = this.worldPosition.relative(direction);
            for (BlockPos position : new BlockPos[]{blockPos, blockPos.above()}) {
                BlockState state = this.level.getBlockState(position);
                if (!(state.getBlock() instanceof ReflectorBlock) || !ReflectorBlock.isFacingTo(state, direction.getOpposite())) continue;
                ++count;
            }
        }
        return count;
    }

    @Nonnull
    public int[] getSlotsForFace(@Nonnull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_UP;
        }
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return direction != Direction.UP && index == 1;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    protected void setItems(@Nonnull NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getRecipeCookTime();
            this.cookTime = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(Player p_235645_1_) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(p_235645_1_.level(), p_235645_1_.position());
        p_235645_1_.awardRecipes(list);
        this.usedRecipes.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(Level p_235640_1_, Vec3 p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
            p_235640_1_.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipeHolder -> {
                list.add(recipeHolder);
                SolarCookerBlockEntity.createExperience(p_235640_1_, p_235640_2_, entry.getIntValue(), ((AbstractCookingRecipe)recipeHolder.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(Level p_235641_0_, Vec3 p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = Mth.floor((float)((float)p_235641_2_ * p_235641_3_));
        float f = Mth.frac((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.getExperienceValue((int)i);
            i -= j;
            p_235641_0_.addFreshEntity((Entity)new ExperienceOrb(p_235641_0_, p_235641_1_.x, p_235641_1_.y, p_235641_1_.z, j));
        }
    }

    public void fillStackedContents(@Nonnull StackedContents helper) {
        for (ItemStack itemstack : this.items) {
            helper.accountStack(itemstack);
        }
    }

    public float getOpenNess(float partialTicks) {
        if (this.level != null) {
            return Mth.lerp((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
        }
        return 0.0f;
    }
}

