/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.solarcooker.compat;

import de.cech12.solarcooker.blockentity.SolarCookerBlockEntity;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;

public class TOPCompat {
    public static void register() {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", PluginTOPRegistry::new);
    }

    public static class PluginTOPRegistry
    implements Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe probe) {
            probe.registerProvider(new IProbeInfoProvider(this){

                public ResourceLocation getID() {
                    return new ResourceLocation("solarcooker", "solarcookerinfo");
                }

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
                    BlockEntity blockEntity = level.getBlockEntity(iProbeHitData.getPos());
                    if (blockEntity instanceof SolarCookerBlockEntity) {
                        SolarCookerBlockEntity solarCookerBlockEntity = (SolarCookerBlockEntity)blockEntity;
                        int cookTime = solarCookerBlockEntity.getCookTime();
                        int cookTimeTotal = solarCookerBlockEntity.getCookTimeTotal();
                        if (cookTime > 0) {
                            iProbeInfo.progress(cookTime, cookTimeTotal, (IProgressStyle)new ProgressStyle().suffix((Component)Component.literal((String)(" / " + cookTimeTotal))).alignment(ElementAlignment.ALIGN_CENTER));
                        }
                    }
                }
            });
            return null;
        }
    }
}

