/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.block;

import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import slexom.earthtojava.entity.passive.MelonGolemEntity;
import slexom.earthtojava.init.BlockInit;
import slexom.earthtojava.init.EntityTypesInit;

public class CarvedMelonBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Predicate<BlockState> IS_MELON = blockState -> blockState != null && (blockState.m_60734_() == BlockInit.CARVED_MELON.get() || blockState.m_60734_() == BlockInit.MELON_LANTERN.get());
    @Nullable
    private BlockPattern snowmanBasePattern;
    @Nullable
    private BlockPattern snowmanPattern;

    public CarvedMelonBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static void spawnEntity(Level world, BlockPattern.BlockPatternMatch patternResult, Entity entity, BlockPos pos) {
        CarvedMelonBlock.breakPatternBlocks(world, patternResult);
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
        world.m_7967_(entity);
        for (ServerPlayer serverplayerentity : world.m_45976_(ServerPlayer.class, entity.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverplayerentity, entity);
        }
        CarvedMelonBlock.updatePatternBlocks(world, patternResult);
    }

    public static void breakPatternBlocks(Level world, BlockPattern.BlockPatternMatch patternResult) {
        for (int i = 0; i < patternResult.m_155970_(); ++i) {
            for (int j = 0; j < patternResult.m_155971_(); ++j) {
                BlockInWorld cachedBlockPosition = patternResult.m_61229_(i, j, 0);
                world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
            }
        }
    }

    public static void updatePatternBlocks(Level world, BlockPattern.BlockPatternMatch patternResult) {
        for (int i = 0; i < patternResult.m_155970_(); ++i) {
            for (int j = 0; j < patternResult.m_155971_(); ++j) {
                BlockInWorld cachedBlockPosition = patternResult.m_61229_(i, j, 0);
                world.m_6289_(cachedBlockPosition.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.trySpawnGolem(world, pos);
        }
    }

    public boolean canDispense(LevelReader worldView, BlockPos pos) {
        return this.getSnowmanBasePattern().m_61184_(worldView, pos) != null;
    }

    private void trySpawnGolem(Level world, BlockPos pos) {
        MelonGolemEntity melonGolemEntity;
        BlockPattern.BlockPatternMatch result = this.getSnowmanPattern().m_61184_((LevelReader)world, pos);
        if (result != null && (melonGolemEntity = (MelonGolemEntity)((EntityType)EntityTypesInit.MELON_GOLEM_REGISTRY_OBJECT.get()).m_20615_(world)) != null) {
            CarvedMelonBlock.spawnEntity(world, result, (Entity)melonGolemEntity, result.m_61229_(0, 2, 0).m_61176_());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private BlockPattern getSnowmanBasePattern() {
        if (this.snowmanBasePattern == null) {
            this.snowmanBasePattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowmanBasePattern;
    }

    private BlockPattern getSnowmanPattern() {
        if (this.snowmanPattern == null) {
            this.snowmanPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#", "#"}).m_61244_('^', BlockInWorld.m_61169_(IS_MELON)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowmanPattern;
    }
}

