/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.client.renderer.entity.TextureUtils;
import slexom.earthtojava.client.renderer.entity.feature.FurnaceGolemFlamesFeatureRenderer;
import slexom.earthtojava.client.renderer.entity.feature.FurnaceGolemTorchFeatureRenderer;
import slexom.earthtojava.entity.passive.FurnaceGolemEntity;

@OnlyIn(value=Dist.CLIENT)
public class FurnaceGolemRenderer
extends MobRenderer<FurnaceGolemEntity, IronGolemModel<FurnaceGolemEntity>> {
    public FurnaceGolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new IronGolemModel(context.m_174023_(ModelLayers.f_171192_)), 0.7f);
        this.m_115326_(new FurnaceGolemFlamesFeatureRenderer((RenderLayerParent<FurnaceGolemEntity, IronGolemModel<FurnaceGolemEntity>>)this));
        this.m_115326_(new FurnaceGolemTorchFeatureRenderer((RenderLayerParent<FurnaceGolemEntity, IronGolemModel<FurnaceGolemEntity>>)this));
    }

    protected void setupTransforms(FurnaceGolemEntity furnaceGolemEntity, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta) {
        super.m_7523_((LivingEntity)furnaceGolemEntity, matrices, animationProgress, bodyYaw, tickDelta);
        if ((double)furnaceGolemEntity.f_267362_.m_267731_() < 0.01) {
            return;
        }
        float f1 = furnaceGolemEntity.f_267362_.m_267590_(tickDelta) + 6.0f;
        float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
        matrices.m_252781_(Axis.f_252403_.m_252977_(6.5f * f2));
    }

    public ResourceLocation getTexture(FurnaceGolemEntity entity) {
        ResourceLocation texture = TextureUtils.getTextureIdentifier("iron_golem", "furnace_golem");
        ResourceLocation textureBlink = TextureUtils.getTextureIdentifier("iron_golem", "furnace_golem", "blink");
        ResourceLocation textureAngry = TextureUtils.getTextureIdentifier("iron_golem", "furnace_golem", "angry");
        if (entity.isAngry()) {
            return textureAngry;
        }
        if (entity.blinkManager.getBlinkRemainingTicks() > 0) {
            return textureBlink;
        }
        return texture;
    }
}

