/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.MessageFormat;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.passive.TropicalSlimeEntity;

@OnlyIn(value=Dist.CLIENT)
public class TropicalSlimeRenderer
extends MobRenderer<TropicalSlimeEntity, SlimeModel<TropicalSlimeEntity>> {
    private static final int ANIMATION_FRAMES = 48;
    private static final float ANIMATION_TIME = 12.0f;
    private int currentFrame = 0;

    public TropicalSlimeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SlimeModel(context.m_174023_(ModelLayers.f_171241_)), 0.25f);
        this.m_115326_((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, context.m_174027_()));
    }

    public void render(TropicalSlimeEntity slimeEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light) {
        this.f_114477_ = 1.0f;
        this.currentFrame = (int)(Math.floor((float)slimeEntity.f_19797_ / 12.0f) % 48.0);
        super.m_7392_((Mob)slimeEntity, entityYaw, partialTicks, matrixStack, vertexConsumerProvider, light);
    }

    protected void scale(TropicalSlimeEntity slimeEntity, PoseStack matrices, float amount) {
        matrices.m_85841_(0.999f, 0.999f, 0.999f);
        matrices.m_85837_(0.0, 0.001, 0.0);
        float f1 = 4.0f;
        float f2 = Mth.m_14179_((float)amount, (float)slimeEntity.lastStretch, (float)slimeEntity.stretch) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        matrices.m_85841_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }

    public ResourceLocation getTexture(TropicalSlimeEntity entity) {
        String frameLocation = MessageFormat.format("earthtojavamobs:textures/mobs/slime/tropical_slime/tropical_slime_anim_{0}.png", this.currentFrame + 1);
        return new ResourceLocation(frameLocation);
    }
}

