/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.passive.JollyLlamaEntity;

@OnlyIn(value=Dist.CLIENT)
public class JollyLlamaModel
extends EntityModel<JollyLlamaEntity> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private float headPitchModifier;

    public JollyLlamaModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
    }

    public static LayerDefinition getTexturedModelData(CubeDeformation dilation) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -14.0f, -10.0f, 4.0f, 4.0f, 9.0f, dilation).m_171514_(0, 14).m_171525_("neck", -4.0f, -16.0f, -6.0f, 8.0f, 18.0f, 6.0f, dilation).m_171514_(17, 0).m_171525_("ear", -4.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, dilation).m_171514_(17, 0).m_171525_("ear", 1.0f, -19.0f, -4.0f, 3.0f, 3.0f, 2.0f, dilation).m_171514_(96, 16).m_171525_("bells", -4.5f, -16.0f, -6.5f, 9.0f, 18.0f, 7.0f, dilation).m_171514_(96, 0).m_171525_("berries", -2.5f, -14.05f, -10.5f, 5.0f, 5.0f, 10.0f, dilation).m_171514_(0, 47).m_171525_("horn_left", 4.5f, -30.0f, -2.0f, 8.0f, 16.0f, 1.0f, dilation).m_171514_(0, 47).m_171480_().m_171525_("horn_right", -12.5f, -30.0f, -2.0f, 8.0f, 16.0f, 1.0f, dilation), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-6.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, dilation), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder modelPartBuilder = CubeListBuilder.m_171558_().m_171514_(29, 29).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, dilation);
        modelPartData.m_171599_("right_hind_leg", modelPartBuilder, PartPose.m_171419_((float)-3.5f, (float)10.0f, (float)6.0f));
        modelPartData.m_171599_("left_hind_leg", modelPartBuilder, PartPose.m_171419_((float)3.5f, (float)10.0f, (float)6.0f));
        modelPartData.m_171599_("right_front_leg", modelPartBuilder, PartPose.m_171419_((float)-3.5f, (float)10.0f, (float)-5.0f));
        modelPartData.m_171599_("left_front_leg", modelPartBuilder, PartPose.m_171419_((float)3.5f, (float)10.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)64);
    }

    public void setAngles(JollyLlamaEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrices.m_85836_();
            matrices.m_85841_(0.71428573f, 0.64935064f, 0.7936508f);
            matrices.m_85837_(0.0, 1.3125, 0.22);
            this.head.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_85841_(0.625f, 0.45454544f, 0.45454544f);
            matrices.m_85837_(0.0, 2.0625, 0.0);
            this.body.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_85841_(0.45454544f, 0.41322312f, 0.45454544f);
            matrices.m_85837_(0.0, 2.0625, 0.0);
            ImmutableList.of((Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg).forEach(modelPart -> modelPart.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
            matrices.m_85849_();
        } else {
            ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg).forEach(modelPart -> modelPart.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
        }
    }

    public void animateModel(JollyLlamaEntity entity, float limbAngle, float limbDistance, float tickDelta) {
        super.m_6839_((Entity)entity, limbAngle, limbDistance, tickDelta);
        this.head.f_104201_ = 6.0f + entity.getNeckAngle(tickDelta) * 9.0f;
        this.headPitchModifier = entity.getHeadAngle(tickDelta);
    }
}

