/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.passive.JumboRabbitEntity;

@OnlyIn(value=Dist.CLIENT)
public class JumboRabbitModel<T extends JumboRabbitEntity>
extends EntityModel<T> {
    private static final String LEFT_HAUNCH = "left_haunch";
    private static final String RIGHT_HAUNCH = "right_haunch";
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHaunch;
    private final ModelPart rightHaunch;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart tail;
    private final ModelPart nose;
    private float jumpProgress;

    public JumboRabbitModel(ModelPart root) {
        this.leftHindLeg = root.m_171324_("left_hind_foot");
        this.rightHindLeg = root.m_171324_("right_hind_foot");
        this.leftHaunch = root.m_171324_(LEFT_HAUNCH);
        this.rightHaunch = root.m_171324_(RIGHT_HAUNCH);
        this.body = root.m_171324_("body");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.head = root.m_171324_("head");
        this.rightEar = root.m_171324_("right_ear");
        this.leftEar = root.m_171324_("left_ear");
        this.tail = root.m_171324_("tail");
        this.nose = root.m_171324_("nose");
    }

    public static LayerDefinition getTexturedModelData() {
        float bodyX = -3.5f;
        float bodyY = -6.0f;
        float bodyZ = -11.5f;
        float headX = bodyX + 1.5f;
        float headY = -8.0f;
        float headZ = -5.0f;
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("left_hind_foot", CubeListBuilder.m_171558_().m_171514_(24, 47).m_171481_(0.0f, 5.5f, -2.7f, 3.0f, 2.0f, 9.0f).m_171480_(), PartPose.m_171419_((float)3.0f, (float)17.5f, (float)3.7f));
        modelPartData.m_171599_("right_hind_foot", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171481_(-2.0f, 5.5f, -2.7f, 3.0f, 2.0f, 9.0f), PartPose.m_171419_((float)-3.0f, (float)17.5f, (float)3.7f));
        modelPartData.m_171599_(LEFT_HAUNCH, CubeListBuilder.m_171558_().m_171514_(42, 14).m_171481_(0.0f, -4.0f, 0.0f, 3.0f, 7.0f, 8.0f).m_171480_(), PartPose.m_171423_((float)3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_(RIGHT_HAUNCH, CubeListBuilder.m_171558_().m_171514_(42, 29).m_171481_(-2.0f, -4.0f, 0.0f, 3.0f, 7.0f, 8.0f), PartPose.m_171423_((float)-3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(bodyX, bodyY, bodyZ, 8.0f, 8.0f, 14.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)8.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(8, 33).m_171481_(0.0f, -3.0f, -2.7f, 2.0f, 11.0f, 3.0f), PartPose.m_171423_((float)3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171481_(-1.0f, -3.0f, -2.7f, 2.0f, 11.0f, 3.0f), PartPose.m_171423_((float)-3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(headX, headY, headZ, 5.0f, 5.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        modelPartData.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171481_(headX - 1.0f, headY - 12.0f, headZ + 4.0f, 3.0f, 10.0f, 1.0f).m_171514_(48, 11).m_171481_(headX, headY - 2.0f, headZ + 4.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        modelPartData.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171481_(headX + 3.0f, headY - 12.0f, headZ + 4.0f, 3.0f, 10.0f, 1.0f).m_171514_(54, 11).m_171481_(headX + 3.0f, headY - 2.0f, headZ + 4.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        modelPartData.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 22).m_171481_(bodyX + 2.5f, bodyY + 1.0f, bodyZ + 14.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)7.0f, (float)-0.3490659f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(22, 27).m_171481_(headX + 2.0f, headY + 2.0f, headZ - 1.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.56666666f, 0.56666666f, 0.56666666f);
            matrixStackIn.m_85837_(0.0, 1.375, 0.125);
            ImmutableList.of((Object)this.head, (Object)this.leftEar, (Object)this.rightEar, (Object)this.nose).forEach(modelPart -> modelPart.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.4f, 0.4f, 0.4f);
            matrixStackIn.m_85837_(0.0, 2.25, 0.0);
            ImmutableList.of((Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail).forEach(modelPart -> modelPart.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        } else {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
            matrixStackIn.m_85837_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.head, (Object)this.rightEar, (Object)this.leftEar, (Object)this.tail, (Object)this.nose, (Object[])new ModelPart[0]).forEach(modelPart -> modelPart.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    public void setAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((JumboRabbitEntity)((Object)entity)).f_19797_;
        this.nose.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightEar.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftEar.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.nose.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.rightEar.f_104204_ = this.nose.f_104204_ - 0.2617994f;
        this.leftEar.f_104204_ = this.nose.f_104204_ + 0.2617994f;
        this.jumpProgress = Mth.m_14031_((float)(entity.m_29735_(f) * (float)Math.PI));
        this.leftHaunch.f_104203_ = (this.jumpProgress * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightHaunch.f_104203_ = (this.jumpProgress * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.leftHindLeg.f_104203_ = this.jumpProgress * 50.0f * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = this.jumpProgress * 50.0f * ((float)Math.PI / 180);
        this.leftFrontLeg.f_104203_ = (this.jumpProgress * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightFrontLeg.f_104203_ = (this.jumpProgress * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void animateModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.jumpProgress = Mth.m_14031_((float)(entityIn.m_29735_(partialTick) * (float)Math.PI));
    }
}

