/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.monster.SkeletonWolfEntity;

@OnlyIn(value=Dist.CLIENT)
public class SkeletonWolfModel<T extends SkeletonWolfEntity>
extends ColorableAgeableListModel<T> {
    private static final String REAL_HEAD = "real_head";
    private static final String UPPER_BODY = "upper_body";
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart torso;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart neck;

    public SkeletonWolfModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.realHead = this.head.m_171324_(REAL_HEAD);
        this.torso = root.m_171324_("body");
        this.neck = root.m_171324_(UPPER_BODY);
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.tail = root.m_171324_("tail");
        this.realTail = this.tail.m_171324_(REAL_TAIL);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData2 = modelPartData.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        modelPartData2.m_171599_(REAL_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f).m_171514_(16, 14).m_171481_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).m_171514_(16, 14).m_171481_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).m_171514_(0, 10).m_171481_(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171481_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_(UPPER_BODY, CubeListBuilder.m_171558_().m_171514_(21, 0).m_171481_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder modelPartBuilder = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f);
        modelPartData.m_171599_("right_hind_leg", modelPartBuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        modelPartData.m_171599_("left_hind_leg", modelPartBuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        modelPartData.m_171599_("right_front_leg", modelPartBuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        modelPartData.m_171599_("left_front_leg", modelPartBuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition modelPartData3 = modelPartData.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        modelPartData3.m_171599_(REAL_TAIL, CubeListBuilder.m_171558_().m_171514_(9, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.torso, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.neck);
    }

    public void animateModel(T entity, float limbAngle, float limbDistance, float tickDelta) {
        this.tail.f_104204_ = ((SkeletonWolfEntity)((Object)entity)).isAngry() ? 0.0f : Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.torso.m_104227_(0.0f, 14.0f, 2.0f);
        this.torso.f_104203_ = 1.5707964f;
        this.neck.m_104227_(-1.0f, 14.0f, -3.0f);
        this.neck.f_104203_ = this.torso.f_104203_;
        this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
        this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
        this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
        this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
        this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.tail.f_104203_ = animationProgress;
    }
}

