/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.ai.control;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import slexom.earthtojava.entity.passive.TropicalSlimeEntity;

public class TropicalSlimeMoveControl
extends MoveControl {
    private final TropicalSlimeEntity slime;
    private float targetYaw;
    private int ticksUntilJump;
    private boolean jumpOften;

    public TropicalSlimeMoveControl(TropicalSlimeEntity slime) {
        super((Mob)slime);
        this.slime = slime;
        this.targetYaw = 180.0f * slime.m_146908_() / (float)Math.PI;
    }

    public void look(float targetYaw, boolean jumpOften) {
        this.targetYaw = targetYaw;
        this.jumpOften = jumpOften;
    }

    public void move(double speed) {
        this.f_24978_ = speed;
        this.f_24981_ = MoveControl.Operation.MOVE_TO;
    }

    public void m_8126_() {
        this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.targetYaw, 90.0f));
        this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            this.f_24974_.m_21564_(0.0f);
            return;
        }
        this.f_24981_ = MoveControl.Operation.WAIT;
        if (this.f_24974_.m_20096_()) {
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            if (this.ticksUntilJump-- <= 0) {
                this.ticksUntilJump = this.slime.getTicksUntilNextJump();
                if (this.jumpOften) {
                    this.ticksUntilJump /= 3;
                }
                this.slime.m_21569_().m_24901_();
                if (this.slime.makesJumpSound()) {
                    this.slime.m_5496_(this.slime.getJumpSound(), 1.0f, this.slime.getJumpSoundPitch());
                }
            } else {
                this.slime.f_20900_ = 0.0f;
                this.slime.f_20902_ = 0.0f;
                this.f_24974_.m_7910_(0.0f);
            }
        } else {
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
        }
    }
}

