/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.base.E2JBaseCowEntity;

public class E2JBaseShearableCowEntity
extends E2JBaseCowEntity
implements Shearable {
    private static final EntityDataAccessor<Byte> isSheared = SynchedEntityData.m_135353_(E2JBaseShearableCowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final ItemStack wool;
    private int eatGrassTimer;
    private EatBlockGoal eatGrassGoal;

    public E2JBaseShearableCowEntity(EntityType<? extends E2JBaseShearableCowEntity> type, Level world, ItemStack wool) {
        super(type, world);
        this.wool = wool;
        this.f_21364_ = 3;
        this.m_21557_(false);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(5, (Goal)this.eatGrassGoal);
    }

    protected void m_8024_() {
        this.eatGrassTimer = this.eatGrassGoal.m_25213_();
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.m_7822_(status);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(isSheared, (Object)0);
    }

    public boolean isSheared() {
        return ((Byte)this.f_19804_.m_135370_(isSheared) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.f_19804_.m_135370_(isSheared);
        if (sheared) {
            this.f_19804_.m_135381_(isSheared, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(isSheared, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(30);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() instanceof ShearsItem) {
            if (!this.m_9236_().f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)this.wool.m_41720_(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        return this.eatGrassTimer < 4 ? ((float)this.eatGrassTimer - delta) / 4.0f : -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatGrassTimer > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public ResourceLocation m_7582_() {
        if (this.isSheared()) {
            return new ResourceLocation("minecraft", "entities/cow");
        }
        return this.m_6095_().m_20677_();
    }
}

