/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.monster;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import slexom.earthtojava.init.SoundEventsInit;

public class SkeletonWolfEntity
extends Monster
implements NeutralMob {
    protected static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(SkeletonWolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private float headRotationCourse;
    private float headRotationCourseOld;
    private UUID targetUuid;

    public SkeletonWolfEntity(EntityType<SkeletonWolfEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.m_21557_(false);
    }

    public static AttributeSupplier.Builder createSkeletonWolfAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)SoundEventsInit.SKELETON_WOLF_GROWL.get();
        }
        if (this.f_19796_.m_188503_(3) == 0 && this.m_21223_() < 10.0f) {
            return (SoundEvent)SoundEventsInit.SKELETON_WOLF_WHINE.get();
        }
        return (SoundEvent)SoundEventsInit.SKELETON_WOLF_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SoundEventsInit.SKELETON_WOLF_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventsInit.SKELETON_WOLF_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)SoundEventsInit.SKELETON_WOLF_STEP.get(), 0.35f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        return 0.62831855f;
    }

    public boolean isAngry() {
        return this.m_6784_() > 0;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)ticks);
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f;
        }
    }
}

