/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.passive;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slexom.earthtojava.entity.ai.goal.HornedSheepActiveTargetGoal;
import slexom.earthtojava.entity.ai.goal.HornedSheepMeleeAttackGoal;
import slexom.earthtojava.entity.ai.goal.HornedSheepRevengeGoal;
import slexom.earthtojava.entity.base.E2JBaseSheepEntity;

public class HornedSheepEntity
extends E2JBaseSheepEntity
implements NeutralMob,
Shearable {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(HornedSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(HornedSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private EatBlockGoal eatGrassGoal;
    private UUID lastHurtBy;

    public HornedSheepEntity(EntityType<? extends HornedSheepEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createHornedSheepAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    protected void m_8099_() {
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)this.eatGrassGoal);
        this.f_21345_.m_25352_(5, (Goal)new HornedSheepMeleeAttackGoal(this, 1.4, true));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HornedSheepRevengeGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new HornedSheepActiveTargetGoal(this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(entityIn.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void m_6703_(@Nullable LivingEntity livingBase) {
        super.m_6703_(livingBase);
        if (livingBase != null) {
            this.lastHurtBy = livingBase.m_20148_();
        }
    }

    protected void m_8024_() {
        if (this.isAngry()) {
            int i = this.getAnger();
            this.setAnger(i - 1);
            LivingEntity livingentity = this.m_5448_();
            if (i == 0 && livingentity != null) {
                this.setSheepAttacker((Entity)livingentity);
            }
        }
    }

    public boolean isAngry() {
        return this.getAnger() > 0;
    }

    private int getAnger() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    private void setAnger(int angerTime) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)angerTime);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            boolean flag = this.isAngry() && this.m_5448_() != null && this.m_5448_().m_20280_((Entity)this) < 4.0;
            this.setNearTarget(flag);
        }
    }

    private void setNearTarget(boolean p_226452_1_) {
        this.setSheepFlag(p_226452_1_);
    }

    private void setSheepFlag(boolean p_226404_2_) {
        if (p_226404_2_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | 2)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 0xFFFFFFFD)));
        }
    }

    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return this.m_6095_().m_20677_();
        }
        return switch (this.m_29874_()) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/white");
            case DyeColor.ORANGE -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/orange");
            case DyeColor.MAGENTA -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/magenta");
            case DyeColor.LIGHT_BLUE -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/light_blue");
            case DyeColor.YELLOW -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/yellow");
            case DyeColor.LIME -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/lime");
            case DyeColor.PINK -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/pink");
            case DyeColor.GRAY -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/gray");
            case DyeColor.LIGHT_GRAY -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/light_gray");
            case DyeColor.CYAN -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/cyan");
            case DyeColor.PURPLE -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/purple");
            case DyeColor.BLUE -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/blue");
            case DyeColor.BROWN -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/brown");
            case DyeColor.GREEN -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/green");
            case DyeColor.RED -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/red");
            case DyeColor.BLACK -> new ResourceLocation("earthtojavamobs", "entities/horned_sheep/black");
        };
    }

    public boolean setSheepAttacker(Entity attacker) {
        this.setAnger(400 + this.f_19796_.m_188503_(400));
        if (attacker instanceof LivingEntity) {
            this.m_6703_((LivingEntity)attacker);
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (!this.m_9236_().f_46443_ && entity instanceof Player && !((Player)entity).m_7500_() && this.m_142582_(entity) && !this.m_21525_()) {
            this.setSheepAttacker(entity);
        }
        return super.m_6469_(source, amount);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID m_6120_() {
        return this.lastHurtBy;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.lastHurtBy = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }
}

