/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.passive;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LlamaFollowCaravanGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import slexom.earthtojava.entity.ai.goal.JollyLlamaEatFernGoal;
import slexom.earthtojava.entity.base.E2JBaseLlamaEntity;
import slexom.earthtojava.init.SoundEventsInit;

public class JollyLlamaEntity
extends E2JBaseLlamaEntity {
    private int eatFernTimer;
    private JollyLlamaEatFernGoal eatFernGoal;

    public JollyLlamaEntity(EntityType<JollyLlamaEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.eatFernGoal = new JollyLlamaEatFernGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new LlamaFollowCaravanGoal((Llama)this, 2.1));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)this.eatFernGoal);
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        this.eatFernTimer = this.eatFernGoal.getTimer();
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatFernTimer = Math.max(0, this.eatFernTimer - 1);
        }
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte status) {
        if (status == 10) {
            this.eatFernTimer = 40;
        } else {
            super.m_7822_(status);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getNeckAngle(float delta) {
        if (this.eatFernTimer <= 0) {
            return 0.0f;
        }
        if (this.eatFernTimer >= 4 && this.eatFernTimer <= 36) {
            return 1.0f;
        }
        return this.eatFernTimer < 4 ? ((float)this.eatFernTimer - delta) / 4.0f : -((float)(this.eatFernTimer - 40) - delta) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadAngle(float delta) {
        if (this.eatFernTimer > 4 && this.eatFernTimer <= 36) {
            float f = ((float)(this.eatFernTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatFernTimer > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public void m_8035_() {
        this.m_5496_((SoundEvent)SoundEventsInit.JOLLY_LLAMA_EAT.get(), 0.5f, 1.0f);
    }

    public void m_8032_() {
        super.m_8032_();
        this.m_5496_((SoundEvent)SoundEventsInit.JOLLY_LLAMA_BELL.get(), 0.3f, 1.0f);
    }

    public boolean m_7066_(ItemStack stack) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7848_(Animal other) {
        return false;
    }

    @Nullable
    public DyeColor m_30826_() {
        return null;
    }
}

