/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import slexom.earthtojava.entity.BlinkManager;
import slexom.earthtojava.entity.ai.control.MelonGolemMoveControl;
import slexom.earthtojava.entity.ai.goal.MelonGolemHopGoal;
import slexom.earthtojava.entity.ai.goal.MelonGolemProjectileAttackGoal;
import slexom.earthtojava.entity.passive.TropicalSlimeEntity;
import slexom.earthtojava.entity.projectile.MelonSeedProjectileEntity;
import slexom.earthtojava.init.SoundEventsInit;

public class MelonGolemEntity
extends AbstractGolem
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> MELON_EQUIPPED = SynchedEntityData.m_135353_(MelonGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.m_135353_(MelonGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final BlinkManager blinkManager = new BlinkManager();

    public MelonGolemEntity(EntityType<? extends MelonGolemEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MelonGolemMoveControl(this);
    }

    public static AttributeSupplier.Builder createMelonGolemAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MelonGolemProjectileAttackGoal(this, 1.25, 20, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new MelonGolemHopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> entity instanceof Enemy && !(entity instanceof TropicalSlimeEntity)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MELON_EQUIPPED, (Object)16);
        this.f_19804_.m_135372_(SHOOTING_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Pumpkin", this.isMelonEquipped());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Pumpkin")) {
            this.setMelonEquipped(compound.m_128471_("Pumpkin"));
        }
    }

    public void m_8107_() {
        int currentShootingTicks;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263828_)) {
                this.m_6469_(this.m_269291_().m_269549_(), 1.0f);
            }
            if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                return;
            }
            BlockState blockState = Blocks.f_50125_.m_49966_();
            for (int l = 0; l < 4; ++l) {
                int posX = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                int posY = Mth.m_14107_((double)this.m_20186_());
                int posZ = Mth.m_14107_((double)(this.m_20189_() + ((double)l / 2.0 % 2.0 * 2.0 - 1.0) * 0.25));
                BlockPos blockPos = new BlockPos(posX, posY, posZ);
                if (!this.m_9236_().m_8055_(blockPos).m_60795_() || !blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) continue;
                this.m_9236_().m_46597_(blockPos, blockState);
                this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
            }
        }
        if ((currentShootingTicks = ((Integer)this.f_19804_.m_135370_(SHOOTING_TICKS)).intValue()) > 0) {
            this.f_19804_.m_135381_(SHOOTING_TICKS, (Object)(--currentShootingTicks));
        }
        this.blinkManager.tickBlink();
    }

    public boolean isShooting() {
        return (Integer)this.f_19804_.m_135370_(SHOOTING_TICKS) > 0;
    }

    public void setShootingTicks() {
        this.f_19804_.m_135381_(SHOOTING_TICKS, (Object)8);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.setShootingTicks();
        MelonSeedProjectileEntity melonSeedEntity = new MelonSeedProjectileEntity(this.m_9236_(), (LivingEntity)this);
        double d0 = target.m_20188_() - 1.1;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - melonSeedEntity.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * 0.2;
        melonSeedEntity.m_6686_(d1, d2 + f, d3, 1.6f, 12.0f);
        this.m_5496_((SoundEvent)SoundEventsInit.MELON_GOLEM_ATTACK.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)melonSeedEntity);
    }

    public float m_20236_(Pose poseIn) {
        return 1.7f;
    }

    public boolean isMelonEquipped() {
        return ((Byte)this.f_19804_.m_135370_(MELON_EQUIPPED) & 0x10) != 0;
    }

    public void setMelonEquipped(boolean melonEquipped) {
        byte b0 = (Byte)this.f_19804_.m_135370_(MELON_EQUIPPED);
        if (melonEquipped) {
            this.f_19804_.m_135381_(MELON_EQUIPPED, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(MELON_EQUIPPED, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12476_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12478_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12477_;
    }

    public int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 5;
    }

    protected void m_6135_() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, (double)this.m_6118_() * 0.1, vec3d.f_82481_);
        this.f_19812_ = true;
    }
}

