/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slexom.earthtojava.entity.ai.goal.MuddyPigMoveToTargetGoal;
import slexom.earthtojava.entity.base.E2JBasePigEntity;

public class MuddyPigEntity
extends E2JBasePigEntity {
    private static final EntityDataAccessor<Boolean> MUDDY_STATE = SynchedEntityData.m_135353_(MuddyPigEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42620_, Items.f_42732_});
    private int outOfMud = 0;
    private int finallyInMud = 0;
    private boolean isShaking;
    private float timeMuddyPigIsShaking;
    private float prevTimeMuddyPigIsShaking;

    public MuddyPigEntity(EntityType<MuddyPigEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42684_}), false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new MuddyPigMoveToTargetGoal(this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 100));
    }

    private boolean isOverMudBlock() {
        int x = Mth.m_14107_((double)this.m_20185_());
        int y = Mth.m_14107_((double)this.m_20186_());
        int z = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockPos = new BlockPos(x, y, z).m_7495_();
        return this.m_9236_().m_8055_(blockPos).m_60734_().equals(Blocks.f_220864_);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isOverMudBlock()) {
            if (this.isInMuddyState()) {
                return;
            }
            if (!this.isShaking) {
                this.isShaking = true;
                this.timeMuddyPigIsShaking = 0.0f;
                this.prevTimeMuddyPigIsShaking = 0.0f;
                this.m_9236_().m_7605_((Entity)this, (byte)8);
            }
            if (++this.finallyInMud > 60) {
                this.setMuddyState(true);
                this.finallyInMud = 0;
                this.resetShake();
            }
        } else {
            if (!this.isInMuddyState()) {
                return;
            }
            ++this.outOfMud;
            if (this.outOfMud > 60) {
                this.setMuddyState(false);
                this.outOfMud = 0;
            }
        }
    }

    private void resetShake() {
        this.isShaking = false;
        this.prevTimeMuddyPigIsShaking = 0.0f;
        this.timeMuddyPigIsShaking = 0.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (!this.isShaking) {
            return;
        }
        this.prevTimeMuddyPigIsShaking = this.timeMuddyPigIsShaking;
        this.timeMuddyPigIsShaking += 0.033f;
        if (this.prevTimeMuddyPigIsShaking >= 2.0f) {
            this.resetShake();
        }
    }

    public void m_6667_(DamageSource cause) {
        this.resetShake();
        super.m_6667_(cause);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MUDDY_STATE, (Object)false);
    }

    public boolean isInMuddyState() {
        return (Boolean)this.f_19804_.m_135370_(MUDDY_STATE);
    }

    public void setMuddyState(boolean inMud) {
        this.f_19804_.m_135381_(MUDDY_STATE, (Object)inMud);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsInMud", this.isInMuddyState());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMuddyState(compound.m_128471_("IsInMud"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte status) {
        if (status == 8) {
            this.isShaking = true;
            this.timeMuddyPigIsShaking = 0.0f;
            this.prevTimeMuddyPigIsShaking = 0.0f;
        } else {
            super.m_7822_(status);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float tickDelta, float d) {
        float f = (Mth.m_14179_((float)tickDelta, (float)this.prevTimeMuddyPigIsShaking, (float)this.timeMuddyPigIsShaking) + d) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }
}

