/*
 * Decompiled with CFR 0.152.
 */
package slexom.earthtojava.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import slexom.earthtojava.entity.ai.control.TropicalSlimeMoveControl;
import slexom.earthtojava.entity.ai.goal.TropicalSlimeAttackGoal;
import slexom.earthtojava.entity.ai.goal.TropicalSlimeFaceRandomGoal;
import slexom.earthtojava.entity.ai.goal.TropicalSlimeFloatGoal;
import slexom.earthtojava.entity.ai.goal.TropicalSlimeHopGoal;
import slexom.earthtojava.entity.ai.goal.TropicalSlimeSwimGoal;

public class TropicalSlimeEntity
extends Monster
implements Enemy {
    private final int size;
    public float targetStretch;
    public float stretch;
    public float lastStretch;
    private boolean onGroundLastTick;

    public TropicalSlimeEntity(EntityType<TropicalSlimeEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = this.size = 4;
        this.m_21557_(false);
        this.f_21342_ = new TropicalSlimeMoveControl(this);
        this.setAttributes();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new TropicalSlimeSwimGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TropicalSlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TropicalSlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TropicalSlimeFaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TropicalSlimeHopGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void setAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(16.0);
        this.m_21051_(Attributes.f_22279_).m_22100_(0.6);
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (player.m_150110_().f_35937_) {
            return super.m_6071_(player, hand);
        }
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() != Items.f_42446_) {
            return super.m_6071_(player, hand);
        }
        if (this.m_9236_().f_46443_) {
            return super.m_6071_(player, hand);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 0.0, 0.0, 0.0);
        player.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
        this.spawnWater();
        this.giveTropicalFishBucket(player, itemstack);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private void giveTropicalFishBucket(Player player, ItemStack itemstack) {
        itemstack.m_41774_(1);
        if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42459_))) {
            player.m_36176_(new ItemStack((ItemLike)Items.f_42459_), false);
        }
    }

    private void spawnWater() {
        int x = Mth.m_14107_((double)this.m_20185_());
        int y = Mth.m_14107_((double)this.m_20186_());
        int z = Mth.m_14107_((double)this.m_20189_());
        BlockPos blockPos = new BlockPos(x, y, z);
        BlockState waterState = Blocks.f_49990_.m_49966_();
        this.m_9236_().m_7471_(blockPos, false);
        this.m_9236_().m_7731_(blockPos, waterState, 3);
    }

    protected ParticleOptions getSquishParticle() {
        return ParticleTypes.f_123803_;
    }

    public void m_8119_() {
        this.stretch += (this.targetStretch - this.stretch) * 0.5f;
        this.lastStretch = this.stretch;
        super.m_8119_();
        if (this.m_20096_() && !this.onGroundLastTick) {
            int i = this.size;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                this.m_9236_().m_7106_(this.getSquishParticle(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.targetStretch = -0.5f;
        } else if (!this.m_20096_() && this.onGroundLastTick) {
            this.targetStretch = 1.0f;
        }
        this.onGroundLastTick = this.m_20096_();
        this.updateStretch();
    }

    protected void updateStretch() {
        this.targetStretch *= 0.6f;
    }

    public int getTicksUntilNextJump() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (entityIn instanceof IronGolem && this.canAttack()) {
            this.damage((LivingEntity)entityIn);
        }
    }

    public void m_6123_(Player player) {
        if (this.canAttack()) {
            this.damage((LivingEntity)player);
        }
    }

    protected void damage(LivingEntity livingEntity) {
        if (this.m_6084_()) {
            int i = this.size;
            if (this.m_20280_((Entity)livingEntity) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)livingEntity) && livingEntity.m_6469_(livingEntity.m_269291_().m_269333_((LivingEntity)this), this.getDamageAmount())) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19970_((LivingEntity)this, (Entity)livingEntity);
            }
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.625f * dimensions.f_20378_;
    }

    public boolean canAttack() {
        return this.m_21515_();
    }

    protected float getDamageAmount() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.f_12388_;
    }

    public boolean makesJumpSound() {
        return true;
    }

    public float getJumpSoundPitch() {
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f;
    }

    protected void m_6135_() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, this.m_6118_(), vec3d.f_82481_);
        this.f_19812_ = true;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.f_12387_;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }
}

